package ipatjava.data;
import java.util.*;
import exc.object.*;
import ipatjava.data.block.*;
public class Data
{
	protected Xobject expr=null;
    protected LineNo lineNo=null;

    private int currentIndex=-1;
    private List dataList = new LinkedList();
    private BitSet parent = new BitSet();
    private BitSet child = new BitSet();
	
	protected StatementDataSocket statementDataSocket=null;
    private boolean setIndex = false;

    public Data(Xobject expr,LineNo lineNo)
    {
	this(expr);
	this.lineNo = lineNo;
	//System.out.println(this.lineNo);
    }

    public Data(Xobject expr)
    {
	this.expr=expr;
	//System.out.println(this.getClass().getName());
    }

    public List getDataList(){return dataList;}
    public int getDataListSize(){return dataList.size();}

    public void mergeDataList(Data data)
    {
	this.dataList.add(data);
	this.dataList.addAll(data.getDataList());
    }

    public Data getData(int i){return (Data)dataList.get(i);}

    public void setDataIndex()
    {
	if(!setIndex)
	    for(ListIterator li = dataList.listIterator() ; li.hasNext() ;)
		{
		    int i = li.nextIndex();
		    Data d = (Data)li.next();
		    d.setDataIndex(i);
		}
	setIndex=true;
    }
    
    public void setDataIndex(int index)
    {
	this.currentIndex=index;
    }

    public int getDataIndex()
    {
	return this.currentIndex;
    }

    public void setDataRelation()
    {
	this.setDataIndex();
	this.clearAllRelation();
	for(ListIterator li1 = dataList.listIterator() ; li1.hasNext() ;)
	    {
		Data d1 = (Data)li1.next();
		int i = d1.getDataIndex();
		d1.setChildDataIndex(i);
		List datalist = d1.getDataList();
		for(ListIterator li2 = datalist.listIterator() ; li2.hasNext() ;)
		    {
			Data d2 = (Data)li2.next();
			int j = d2.getDataIndex();
			d1.setChildDataIndex(j);
			d2.setParentDataIndex(i);
		    }
	    }
    }
    
    
    public void clearAllRelation()
    {
	for(ListIterator listIterator1 = dataList.listIterator() ; listIterator1.hasNext() ;)
	    {
		Data data1 = (Data)listIterator1.next();
		data1.getParentDataIndex().xor(data1.getParentDataIndex());
		data1.getChildDataIndex().xor(data1.getChildDataIndex());
	    }	
    }

    public void setParentDataIndex(int i){ parent.set(i);}
    public BitSet getParentDataIndex(){ return parent;}
    
    public void setChildDataIndex(int i){ child.set(i);}
    public BitSet getChildDataIndex(){ return child;}

    public void printAllData()
    {
	for(ListIterator li = dataList.listIterator() ; li.hasNext() ;)
	    {
		Data d = (Data)li.next();
		if( (d instanceof StatementData))
		    if(d.getXobject()!=null)
			System.out.println(d.getDataIndex()+":"+d.getXobject().toString()+d.getParentDataIndex().toString()+d.getChildDataIndex().toString());
		    else
			System.out.println(d.getDataIndex()+":null"+parent.toString()+d.getParentDataIndex().toString()+d.getChildDataIndex().toString());
	    }
    }
   
    public Xobject getXobject(){return expr;}
	public LineNo getLineNo(){return lineNo;}
    public StatementDataSocket getStatementDataSocket(){return statementDataSocket;}

}
