package ipatjava.data;
import java.util.*;
import ipatjava.data.block.*;

public class StatementDataSocket extends DataSocket
{
    public StatementDataSocket(){super();}

    public StatementDataSocket(BlockData blockData)
    {
	super(blockData);
    }

    public StatementDataSocket(BasicBlockData basicBlockData)
    {
	super(basicBlockData);
    }

    public StatementDataSocket(BlockListData blockListData)
    {
	super(blockListData);
    }

    public StatementDataSocket(StatementData statementData)
    {
	setHead(statementData);
	setTail(statementData);
    }

    public void setHead(StatementData statementData){head.add(statementData);}
    public void setTail(StatementData statementData){tail.add(statementData);}
    public void setNext(StatementData statementData){next.add(statementData);}
    public void setPrev(StatementData statementData){prev.add(statementData);}

    public void connectEachOther(DataSocket headDataSocket)
    {
	for(ListIterator li1 = headDataSocket.getHead().listIterator() ; li1.hasNext() ; )
	    {
		Data d1 = (Data)li1.next();
		for(ListIterator li2 = this.getTail().listIterator() ; li2.hasNext() ; )
		    {
			Data d2 = (Data)li2.next();
			if(d1.getStatementDataSocket()!=null && d2.getStatementDataSocket()!=null )
			    {
				d2.getStatementDataSocket().setNext(d1.getStatementDataSocket().getHead());
				d1.getStatementDataSocket().setPrev(d2.getStatementDataSocket().getTail());
			    }
		    }		
	    }
    }
}
