package ipatjava.data.block;
import ipatjava.data.Data;
import ipatjava.data.StatementDataSocket;
import ipatjava.tips.XMLTips;

import java.util.LinkedList;
import java.util.List;

import org.w3c.dom.*;

import exc.block.BasicBlock;
import exc.block.Statement;
import exc.object.LineNo;

public class BasicBlockData extends Data
    implements 
	BasicBlockDataNode
{
    protected BasicBlock current;
    protected BlockData parent;
    protected List statementList = new LinkedList();

    public BasicBlockData(BasicBlock basicBlock,LineNo lineNo,BlockData parent)
    {
	super(basicBlock.toXobject(),lineNo);
	this.current=basicBlock;
	this.parent = parent;

	if(this.current.getHead()!=null)
	    this.iterateBlock();
    }

    private void iterateBlock()
    {
	StatementData prevStatementData=null;

	statementDataSocket = new StatementDataSocket();

	for(Statement statement = this.current.getHead(); statement != null; statement = statement.getNext())
	    {
		StatementData statementData = new StatementData(statement,this);
		if(prevStatementData==null)
		    statementDataSocket.setHead(statementData);
		super.mergeDataList(statementData);
		statementList.add(statementData);
		if(prevStatementData!=null)
		    prevStatementData.getStatementDataSocket().connectEachOther(statementData.getStatementDataSocket());
		prevStatementData=statementData;
	    }
	if(prevStatementData!=null)
		statementDataSocket.setTail(prevStatementData);
    }

    public List getStatementList(){return statementList;}

    public boolean isSingle(){return (statementList.size()==1);}
        
    public Element getXMLElement(Document document)
    {
    		Element element = XMLTips.createElement(document,"BASIC_BLOCK");
    		return 	element;
    }
}
