package ipatjava.data.block;
import java.util.*;
import exc.block.*;
import ipatjava.data.*;

public class BlockListData extends Data
{
    private BlockList body;
    private BlockData parent;
    private List list = new LinkedList();

    public BlockListData(BlockList body,BlockData parent)
    {
	super(body.toXobject(),parent.getLineNo());
	this.body=body;
	this.parent = parent;
	this.iterateBlock();
    }
    
    protected void iterateBlock()
    {
	boolean first = true;
	BlockData prev_bd = null;
	statementDataSocket = new  StatementDataSocket();
	for(Block block = this.body.getHead(); block != null; block = block.getNext())
	    {
		BlockData bd = BlockData.nextBlock(block,this);
		this.list.add(bd);
		super.mergeDataList(bd);
		if(prev_bd==null)
		    statementDataSocket.setHead(bd.getStatementDataSocket().getHead());

		if(prev_bd!=null && !(prev_bd instanceof JumpStatementDataInterface))
		    prev_bd.getStatementDataSocket().connectEachOther(bd.getStatementDataSocket());
		prev_bd=bd;
		first=false;
	    }
	if(prev_bd!=null && !(prev_bd instanceof JumpStatementDataInterface))
	    statementDataSocket.setTail(prev_bd.getStatementDataSocket().getTail());
    }
    
    public List getList(){return this.list;}
}
