package ipatjava.data.block;
import java.util.*;
import exc.object.*;
import exc.block.*;
import ipatjava.data.*;
import ipatjava.data.expr.*;

public class CondBlockData extends BlockData
{
    protected BlockListData body;
    protected CondBasicBlockData cond;
    protected BinaryExprData condExpr = null;
    protected CondBlock current =null;


    public CondBlockData(CondBlock condBlock,BlockListData parent)
    {
	super((Block)condBlock,condBlock.getLineNo(),parent);
	this.parent = parent;
	statementDataSocket = new StatementDataSocket();

	this.current=condBlock;
	this.cond=new CondBasicBlockData(condBlock.getCondBBlock(),this);
	this.body=new BlockListData(condBlock.getBody(),this);

	if(cond.getExprData() instanceof BinaryExprData)
	    condExpr = (BinaryExprData)cond.getExprData();

	switch(current.Opcode())
	    {
	    case Xcode.FOR_STATEMENT:
		break;
	    case Xcode.WHILE_STATEMENT:
		super.mergeDataList(this.cond);
		super.mergeDataList(this.body);

		this.cond.getStatementDataSocket().connectEachOther(this.body.getStatementDataSocket());
		this.body.getStatementDataSocket().connectEachOther(this.cond.getStatementDataSocket());

		statementDataSocket.setHead(this.cond.getStatementDataSocket().getHead());
		statementDataSocket.setTail(this.cond.getStatementDataSocket().getTail());

		if(this.body.getStatementDataSocket().getHead().isEmpty())
		    this.cond.getStatementDataSocket().connectEachOther(this.cond.getStatementDataSocket());

		this.setJumpStatement(this.cond);

		break;
	    case Xcode.DO_STATEMENT:
		super.mergeDataList(this.body);
		super.mergeDataList(this.cond);

		this.cond.getStatementDataSocket().connectEachOther(this.body.getStatementDataSocket());
		this.body.getStatementDataSocket().connectEachOther(this.cond.getStatementDataSocket());

		statementDataSocket.setHead(this.body.getStatementDataSocket().getHead());
		statementDataSocket.setTail(this.cond.getStatementDataSocket().getTail());

		if(this.body.getStatementDataSocket().getHead().isEmpty())
		    {
			statementDataSocket.setHead(this.cond.getStatementDataSocket().getHead());
			this.cond.getStatementDataSocket().connectEachOther(this.cond.getStatementDataSocket());
		    }
		
		this.setJumpStatement(this.cond);

		break;
	    case Xcode.SWITCH_STATEMENT:
		super.mergeDataList(this.cond);
		super.mergeDataList(this.body);
		    	
		this.cond.getStatementDataSocket().connectEachOther(this.body.getStatementDataSocket());
		statementDataSocket.setHead(this.cond.getStatementDataSocket().getHead());
		statementDataSocket.setTail(this.body.getStatementDataSocket().getTail());

		this.setJumpStatement(this.cond);

		if(statementDataSocket.getTail().isEmpty())
		    statementDataSocket.setTail(this.cond.getStatementDataSocket().getTail());

		break;
	    }
    }

    protected void setJumpStatement(Data jp)
    {
	BitSet condBlocks = new BitSet();
	BitSet loopBlocks = new BitSet();
	BitSet switchBlocks = new BitSet();
	BitSet breakStatements = new BitSet();
	BitSet continueStatements = new BitSet();
	BitSet labels = new BitSet();
	List list = super.getDataList();

	super.setDataRelation();

	for(ListIterator li = list.listIterator() ; li.hasNext();)
	    {
		Data d = (Data)li.next();
		if(d instanceof CondBlockData)
		    {
			condBlocks.set(d.getDataIndex());
			if(d.getXobject().Opcode()==Xcode.SWITCH_STATEMENT)
			    switchBlocks.set(d.getDataIndex());
			else
			    loopBlocks.set(d.getDataIndex());			    
		    }
		if(d instanceof BreakStatementData)
		    breakStatements.set(d.getDataIndex());
		if(d instanceof ContinueStatementData)
		    continueStatements.set(d.getDataIndex());
		if(d instanceof CaseLabelData || d instanceof DefaultLabelData)
		    labels.set(d.getDataIndex());
	    }

	for(int i=breakStatements.nextSetBit(0);i!=-1;i=breakStatements.nextSetBit(i+1))
	    {
		SimpleBlockData sbd = (SimpleBlockData)list.get(i);
		BitSet comp = (BitSet)condBlocks.clone();
		comp.and(sbd.getParentDataIndex());
		if(comp.isEmpty())
		    statementDataSocket.setTail(sbd.getStatementDataSocket().getTail());
	    }

	if(this.current.Opcode()==Xcode.SWITCH_STATEMENT)
	    {
		for(int i=labels.nextSetBit(0);i!=-1;i=labels.nextSetBit(i+1))
		    {
			Data d = (Data)list.get(i);
			BitSet comp = (BitSet)switchBlocks.clone();
			comp.and(d.getParentDataIndex());
			if(comp.isEmpty())
			    jp.getStatementDataSocket().connectEachOther(d.getStatementDataSocket());
		    }
	    }
	else
	    {
		for(int i=continueStatements.nextSetBit(0);i!=-1;i=continueStatements.nextSetBit(i+1))
		    {
			SimpleBlockData sbd = (SimpleBlockData)list.get(i);
			BitSet comp = (BitSet)loopBlocks.clone();
			comp.and(sbd.getParentDataIndex());
			if(comp.isEmpty())
			    sbd.getStatementDataSocket().connectEachOther(sbd.getStatementDataSocket());
		    }
	    }
    }

    public BlockListData getBody(){return this.body;}
    public CondBasicBlockData getCond(){return this.cond;}

}
