package ipatjava.data.block;
import exc.block.*;
import ipatjava.data.*;

public class IfBlockData extends BlockData
{
    private BlockListData thenBody,elseBody;
    private CondBasicBlockData cond;

    public IfBlockData(IfBlock ifBlock,BlockListData parent)
	{
	    super((Block)ifBlock,ifBlock.getLineNo(),parent);
	    statementDataSocket = new StatementDataSocket();
	    
	    this.cond=new CondBasicBlockData(ifBlock.getCondBBlock(),this);
	    this.thenBody=new BlockListData(ifBlock.getThenBody(),this);
	    this.elseBody=new BlockListData(ifBlock.getElseBody(),this);
	    
	    super.mergeDataList(this.cond);
	    super.mergeDataList(this.thenBody);
	    super.mergeDataList(this.elseBody);
	    

	    this.cond.getStatementDataSocket().connectEachOther(this.thenBody.getStatementDataSocket());
	    this.cond.getStatementDataSocket().connectEachOther(this.elseBody.getStatementDataSocket());

	    statementDataSocket.setHead(this.cond.getStatementDataSocket().getHead());
	    statementDataSocket.setTail(this.thenBody.getStatementDataSocket().getTail());
	    statementDataSocket.setTail(this.elseBody.getStatementDataSocket().getTail());
	    
	    if(this.thenBody.getStatementDataSocket().getHead().isEmpty()||
	       this.elseBody.getStatementDataSocket().getHead().isEmpty()
	       )
		statementDataSocket.setTail(this.cond.getStatementDataSocket().getTail());
	}
}
