package ipatjava.graph;
import java.util.*;
import ipatjava.data.*;

public class Graph
{
    protected Data data = null;
    protected BitSet node = new BitSet();
    protected BitSet graph[];

    public Graph(Data data){this.data=data;}

    public Graph(Data data,BitSet node)
    {
    	this(node);
    	this.data=data;
    }

    private Graph(BitSet node){setNode(node);}
    
    public void setNode(BitSet node)
    {
	this.node = (BitSet)node.clone();
	graph = new BitSet[this.node.cardinality()];
	for(int i = 0 ; i < this.node.cardinality(); graph[i++] = new BitSet());
    }
	
    public BitSet getNode(){return node;}

    public void set(BitSet[] graph){this.graph=graph;}
    
    public void set(int index,BitSet bitset){this.graph[index]=bitset;}

    public void set(int index,int set){this.graph[index].set(set);}
    
    public int getNodeIndex(int num)
    {
	int i=0;
	for(int j=node.nextSetBit(0);j!=-1;j=node.nextSetBit(j+1))
	    if(j==num)
		return i;
	    else
		i++;
	return -1;
    }

    public BitSet getNodeIndexBitSet(int num)
    {
	BitSet bs = new BitSet();
	int i = getNodeIndex(num);
	if(i!=-1)
	    bs.set(i);
	return bs;
    }

    public BitSet getNodeIndexBitSet(BitSet numbs)
    {
	BitSet bs = new BitSet();
	for(int i = numbs.nextSetBit(0); i!=-1;i=numbs.nextSetBit(i+1))
	    {
		int j = getNodeIndex(i);
		if(j!=-1)
		    bs.set(j);
	    }
	return bs;
    }

    public int getNodeDataIndex(int index)
    {
	int i=0;
	for(int j=node.nextSetBit(0);j!=-1;j=node.nextSetBit(j+1))
	    if(index==i)
		return j;
	    else
		i++;
	return -1;
    }

    public BitSet getNodeDataIndexBitSet(int index)
    {
	BitSet bs = new BitSet();
	int i = getNodeDataIndex(index);
	if(i!=-1)
	    bs.set(i);
	return bs;
    }

    public BitSet getNodeDataIndexBitSet(BitSet indexbs)
    {
	BitSet bs = new BitSet();
	for(int i = indexbs.nextSetBit(0); i!=-1;i= indexbs.nextSetBit(i+1))
	    {
		int j = getNodeDataIndex(i);
		if(j!=-1)
		    bs.set(j);
	    }
	return bs;
    }

    public BitSet[] getGraph(){return graph;}
    public BitSet getGraph(int index){return graph[index];}
    public Data getData(){return this.data;}

    public int size(){return node.cardinality();}

    public void printGraph()
    {
	for(int i = 0 ; i < graph.length ; i++)
	    System.out.println(i+":"+this.getNodeDataIndex(i)+":"+graph[i].toString());
    }
}
