package ipatjava.math;
import exc.object.*;
import java.util.*;
import ipatjava.tips.*;

public class IdValueList
{
    List idl = new LinkedList();
    int intValue;

    public IdValueList(Xobject x,int v)
    {
	this.idl.add(new IdValue(x,v));
	this.intValue = 0;
    }

    public IdValueList(int v){this.intValue = v;}
    
    public IdValueList copy()
    {
	IdValueList ivl = new IdValueList(0);
	ivl.setValue(this.getValue());
	for(ListIterator li = idl.listIterator(); li.hasNext();)
	    {
		IdValue idv = (IdValue)li.next();
		ivl.setValue(idv.getId(),idv.getValue());
	    }
	return ivl;
    }
    
    public int size(){return this.idl.size();}
    
    public List getList(){return this.idl;}
    
    public int getValue(Xobject x)
    {
	IdValue idv = searchId(x);
	if(idv != null)
	    return idv.getValue();
	else
	    return 0;
    }
    
    public int getValue(){return this.intValue;}

    public void setValue(Xobject x,int v)
    {
	IdValue idv = searchId(x);
	if(idv != null)
	    idv.setValue(v);
	else
	    idl.add(new IdValue(x,v)); 
    }

    public void setValue(int v){this.intValue = v;}

    public void removeValue(Xobject x)
    {
	for(ListIterator li = this.idl.listIterator();li.hasNext();)
	    {
		IdValue idv = (IdValue)li.next();
		if( XobjectTips.sameXobject(x,idv.getId()) )
		    li.remove();
	    }
    }

    public IdValue searchId(Xobject x)
    {
	for(ListIterator li = this.idl.listIterator();li.hasNext();)
	    {
		IdValue idv = (IdValue)li.next();
		if(XobjectTips.sameXobject(x,idv.getId()) )
		    return idv;
	    }
	return null;
    }

    public void printAllValue()
    {
	System.out.print("Int Value ="+intValue+"\n");
	for(ListIterator li = this.idl.listIterator();li.hasNext();)
	    {
		IdValue idv = (IdValue)li.next();
		System.out.print("Id = "+idv.getId().toString()+":Value = "+idv.getValue()+"\n");
	    }
    }
}
