package ipatjava.measure;
import ipatjava.tips.XMLTips;

import java.io.File;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.XobjectFile;

public class ExecutionMeasure
{
    public static void main(String args[]){
	
	String infile = null;
	String outfile = "execute_measure.x";
	String funcname = null;
	String xmlSuffix = ".xml";

	int argc = 0;
	int range[] = {0,Integer.MAX_VALUE};
	while(argc<args.length)
	    {
		if(args[argc].substring(0,1).equals("-"))
		    {
			String arg = args[argc].substring(1);
			if(arg.equals("l"))
			    {
				argc++;
				for(int i = 0 ; i < 2 ; i++)
				    try{
					range[i] = Integer.parseInt(args[argc]);
					argc++;
				    }catch (NumberFormatException e)
					{
					    usage("-l:invalid args (isn't number)\n");
					}
				    catch (ArrayIndexOutOfBoundsException e)
					{
					    usage("-l:invalid Arg\n");
					}
				continue;
			    }
			if(arg.equals("o"))
			    {
				argc++;
				try{
				    //xmlName=args[argc];
				    argc++;
				}
				catch (ArrayIndexOutOfBoundsException e)
				    {
					usage("-o:invalid Arg\n");
				    }
				continue;
			    }
			if(arg.equals("f"))
			    {
				argc++;
				try{
				    funcname=args[argc];
				    argc++;
				}
				catch (ArrayIndexOutOfBoundsException e)
				    {
					usage("-f:invalid Arg\n");
				    }
				continue;
			    }
		    }
		else if(argc == args.length-1)
		    infile = args[argc];
		argc++;
	    }

	if(infile==null)
	    usage("Please imput file name.\n");

	File check_f = new File(infile);
	if(!check_f.exists())
	    usage("cannot open file '"+infile+"'\n");   

	Document document = XMLTips.createDocument(); 
	Element rootElement =XMLTips.createElement(document,"measurement_point");
	document.appendChild(rootElement);

	XobjectFile xobjectFile = new XobjectFile(infile,outfile);
	MeasureFunctionBlocks measureFunctionBlocks = new MeasureFunctionBlocks(document);	
	xobjectFile.Input();
	xobjectFile.iterateDef(measureFunctionBlocks);
	
	String source = xobjectFile.getSourceFileName();
	if(source.startsWith("/"))
	    {
		String[] split=source.split("\\/");
		System.out.println(split[split.length-1]);
		source = split[split.length-1];
	    }
	else if(source.startsWith("./"))
	    {
		String[] split=source.split("\\.\\/");
		System.out.println(split[split.length-1]);
		source = split[split.length-1];
	    }

	xobjectFile.Output(infile+"x");
	xobjectFile.Decompile("tmp_"+source);

	XMLTips.writeDocument(document,source+xmlSuffix);	

	//	xobjectFile.Decompile("uhihi.c");
    }

    private static void usage(String str)
    {
	System.out.print(str);
	System.out.print("\n");
	System.out.print("Panalysis [options] xobject_file_name \n");
	System.out.print("options are:\n");
	System.out.print("-l: set analysis area\n");
	System.out.print("-f: set functions analyzed by iPat/OMP\n");
	System.out.print("-p: set default clause 'private'\n");
	System.out.print("-s: set default clause 'shared'\n");
	System.out.print("\n");	
	System.exit(-1);
    } 
}
