package ipatjava.tips;

import ipatjava.data.block.BasicBlockData;
import ipatjava.data.block.CondBasicBlockData;
import ipatjava.data.block.ForBlockData;
import ipatjava.data.block.StatementData;
import ipatjava.data.expr.AsignExprData;
import ipatjava.data.expr.BinaryExprData;
import ipatjava.data.expr.ExprData;

import java.util.List;

import exc.object.Xobject;

public class ForBlockDataTips {
	
	public static Xobject getLoopId(ForBlockData forBlockData)
	{
		CondBasicBlockData condBasicBlockData = forBlockData.getCond();
		ExprData exprData = condBasicBlockData.getExprData();
		if(!(exprData instanceof BinaryExprData))
			return null;
		BinaryExprData binaryExprData = (BinaryExprData)exprData;
		return (Xobject)binaryExprData.left().getXobject();
	}
	
	public static int[] getLowerValue(ForBlockData forBlockData,Xobject id[])
	{
		int col = id.length;
		int result[] = new int[col];
		
		for(int i = 0 ; i < col ; i++)
			result[i] = 0;
		
		BasicBlockData basicBlockData = forBlockData.getInit();
		List statementList = basicBlockData.getStatementList();
		if(statementList.isEmpty() || statementList.size()!=1)
			return result;
		StatementData statementData = (StatementData)statementList.get(0);
		ExprData exprData = statementData.getExprData();
		if(!(exprData instanceof AsignExprData))
			return result;
		AsignExprData asignExprData = (AsignExprData)exprData;
		
		if(asignExprData.right() == null)
			return result;
		if(asignExprData.right().getIdValueList() == null)
			return result;
		
		//initExpr.getR().getIdValueList().printAllValue();
		for(int i = 0 ; i < col ; i++)
			result[i] = asignExprData.right().getIdValueList().getValue(id[i]);
		
		return result;
	}
	
	public static int getLowerValue(ForBlockData forBlockData)
	{
		BasicBlockData basicBlockData = forBlockData.getInit();
		List statementList = basicBlockData.getStatementList();
		if(statementList.isEmpty() || statementList.size()!=1)
			return 0;
		StatementData statementData = (StatementData)statementList.get(0);
		ExprData exprData = statementData.getExprData();
		if(!(exprData instanceof AsignExprData))
			return 0;
		AsignExprData asignExprData = (AsignExprData)exprData;
		
		if(asignExprData.right() == null)
			return 0;
		if(asignExprData.right().getIdValueList() == null)
			return 0;
		
		return asignExprData.right().getIdValueList().getValue();
	}
	
	public static int[] getUpperValue(ForBlockData forBlockData,Xobject id[])
	{
		int col = id.length;
		int result[] = new int[col];
		
		for(int i = 0 ; i < col ; i++)
			result[i] = 0;
		
		CondBasicBlockData condBasicBlockData = forBlockData.getCond();
		ExprData exprData = condBasicBlockData.getExprData();
		
		if(exprData ==null)
			return result;
		if(!(exprData instanceof BinaryExprData))
			return result;
		BinaryExprData binaryExprData = (BinaryExprData)exprData;
		
		if(binaryExprData.right() == null)
			return result;
		if(binaryExprData.right().getIdValueList() == null)
			return result;
		
		//initExpr.getR().getIdValueList().printAllValue();
		for(int i = 0 ; i < col ; i++)
			result[i] = binaryExprData.right().getIdValueList().getValue(id[i]);
		
		return result;
	}
	
	public static int getUpperValue(ForBlockData forBlockData)
	{
		CondBasicBlockData condBasicBlockData = forBlockData.getCond();
		ExprData exprData = condBasicBlockData.getExprData();
		
		if(exprData ==null)
			return 0;
		if(!(exprData instanceof BinaryExprData))
			return 0;
		BinaryExprData binaryExprData = (BinaryExprData)exprData;
		
		if(binaryExprData.right() == null)
			return 0;
		if(binaryExprData.right().getIdValueList() == null)
			return 0;

		if(binaryExprData.right() == null)
			return 0;
		if(binaryExprData.right().getIdValueList() == null)
			return 0;
		
		return binaryExprData.right().getIdValueList().getValue();
	}
	
	   public static int getStrideValue(ForBlockData forBlockData)
	    {
		BasicBlockData basicBlockData = forBlockData.getIter();
		List statementList = basicBlockData.getStatementList();
		if(statementList.isEmpty() || statementList.size()!=1)
			return 0;
		StatementData statementData = (StatementData)statementList.get(0);
		ExprData exprData = statementData.getExprData();
		if(!(exprData instanceof AsignExprData))
			return 0;
		AsignExprData asignExprData = (AsignExprData)exprData;
		
		if(asignExprData.right() == null)
			return 0;
		if(asignExprData.right().getIdValueList() == null)
			return 0;
	
		return asignExprData.right().getIdValueList().getValue();
	    }

}
