package ipatjava.tips;
import ipatjava.data.block.ForBlockData;

import java.util.BitSet;
import java.util.List;

import exc.object.Xobject;

public class LoopBoundTips 
{
    public static Xobject[] getLoopIds(List fbl ,BitSet bs)
    {
	Xobject result[] = new Xobject[bs.cardinality()];
	int counter = 0;
	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++ )
	    result[counter] = ForBlockDataTips.getLoopId((ForBlockData)fbl.get(i));
	return result;
    }

    public static int[][] getLowerMatrix(List fbl ,BitSet bs,Xobject[] x,Xobject []u)
    {
	int row = bs.cardinality()+u.length;
	int col = bs.cardinality()+u.length;
	int tmp1[][] = new int[bs.cardinality()][u.length];
	
	int counter = 0;
	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++)
	    tmp1[counter] = ForBlockDataTips.getLowerValue((ForBlockData)fbl.get(i),x);

	int tmp2[][] = LoopBoundTips.getLowerMatrix(fbl,bs,x);
	
	int result[][] = new int[row][col];

	for(int i = 0 ; i < u.length ; i++)
	    {
		for(int j = i ; j < bs.cardinality() ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j+u.length]=-1*(tmp1[j][i]);
	    }
	
	for(int i = u.length ; i < row ; i++)
	    {
		for(int j = bs.cardinality() ; j < col ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j]=-1*(tmp2[j-bs.cardinality()][i-u.length]);
	    }
	return result;	
    }

    public static int[][] getLowerMatrix(List fbl ,BitSet bs,Xobject[] x)
    {
	int row = bs.cardinality();
	int col = bs.cardinality();
	int tmp[][] = new int[row][col];
	
	int result[][] = new int[row][col];
	int counter = 0;
	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++)
	    tmp[counter] = ForBlockDataTips.getLowerValue((ForBlockData)fbl.get(i),x);

	for(int i = 0 ; i < row ; i++)
	    {
		for(int j = i ; j < col ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j]=-1*(tmp[j][i]);
	    }
	return result;
    }

    public static int[] getLowerVector(List fbl ,BitSet bs,Xobject[] u)
    {
	int tmp[] = LoopBoundTips.getLowerVector(fbl,bs);
	
	int result[] = new int[bs.cardinality()+u.length];
	
	for(int i = 0 ; i < bs.cardinality() ; i++ )
	    result[i+u.length] = tmp[i];
	
	return result;
    }

    public static int[] getLowerVector(List fbl ,BitSet bs)
    {
	int result[] = new int[bs.cardinality()];
	int counter = 0;

	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++ )
	    result[counter] = ForBlockDataTips.getLowerValue((ForBlockData)fbl.get(i));

	return result;
    }

    public static int[][] getUpperMatrix(List fbl ,BitSet bs,Xobject[] x,Xobject []u)
    {
	int row = bs.cardinality()+u.length;
	int col = bs.cardinality()+u.length;
	int tmp1[][] = new int[bs.cardinality()][u.length];
	
	int counter = 0;
	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++)
	    tmp1[counter] = ForBlockDataTips.getUpperValue((ForBlockData)fbl.get(i),x);

	int tmp2[][] = LoopBoundTips.getUpperMatrix(fbl,bs,x);
	
	int result[][] = new int[row][col];

	for(int i = 0 ; i < u.length ; i++)
	    {
		for(int j = i ; j < bs.cardinality() ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j+u.length]=-1*(tmp1[j][i]);
	    }
	
	for(int i = u.length ; i < row ; i++)
	    {
		for(int j = bs.cardinality() ; j < col ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j]=-1*(tmp2[j-bs.cardinality()][i-u.length]);
	    }
	return result;	
    }

    public static int[][] getUpperMatrix(List fbl ,BitSet bs,Xobject[] x)
    {
	int row = bs.cardinality();
	int col = bs.cardinality();
	int tmp[][] = new int[row][col];
	
	int result[][] = new int[row][col];
	int counter = 0;
	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++)
	    tmp[counter] = ForBlockDataTips.getUpperValue((ForBlockData)fbl.get(i),x);

	for(int i = 0 ; i < row ; i++)
	    {
		for(int j = i ; j < col ; j++)
		    if(i==j)
			result[i][j]=1;
		    else
			result[i][j]=-1*(tmp[j][i]);
	    }
	return result;
    }

    public static int[] getUpperVector(List fbl ,BitSet bs,Xobject[] u)
    {
	int tmp[] = LoopBoundTips.getUpperVector(fbl,bs);
	
	int result[] = new int[bs.cardinality()+u.length];
	
	for(int i = 0 ; i < bs.cardinality() ; i++ )
	    result[i+u.length] = tmp[i];
	
	return result;
    }

    public static int[] getUpperVector(List fbl ,BitSet bs)
    {
	int result[] = new int[bs.cardinality()];
	int counter = 0;

	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++ )
	    result[counter] = ForBlockDataTips.getUpperValue((ForBlockData)fbl.get(i));

	return result;
    }

    public static int[][] getStrideMatrix(List fbl ,BitSet bs,Xobject[] u)
    {
	int tmp[][] = LoopBoundTips.getStrideMatrix(fbl,bs);
	
	int result[][] = new int[bs.cardinality()+u.length][bs.cardinality()+u.length];
	
	for(int i = 0 ; i < u.length ; i++ )
	    result[i][i] =1;

	for(int i = 0 ; i < bs.cardinality() ; i++ )
	    result[i+u.length][i+u.length] = tmp[i][i];
	
	return result;
    }

    public static int[][] getStrideMatrix(List fbl ,BitSet bs)
    {
	int result[][] = new int[bs.cardinality()][bs.cardinality()];
	int counter = 0;

	for(int i = bs.nextSetBit(0); i!=-1 ; i = bs.nextSetBit(i+1),counter++ )
	    result[counter][counter] = ForBlockDataTips.getStrideValue((ForBlockData)fbl.get(i));
	return result;
    }
    
                                                                                                                                              

}
