package ipatjava.tips;
import ipatjava.math.*;

public class MathTips
{
    public static int gcd(int i1,int i2)
    {
        if(i2==0)
            return i1;
        else
            return Math.abs(gcd(i2,i1%i2));
    }

    public static int signum(int i)
    {
	if(i>0)
	    return 1;
	if(i<0)
	    return -1;
	return 0;
    }

    public static int getRank(int a[][])
    {
	int m=a.length;
	int n=a[0].length;	

	boolean  nonzero;
	int rank=0;

	for(int i=0;i<m;i++)
	    {
		nonzero=false;
		for(int j=0;j<n;j++)
		    if(MathTips.signum(a[i][j])!=0)
			nonzero=true;
		if(nonzero)
		    rank++;
	    }
	return rank;
    }

   public static int[][] getUnimodularMatrix(int a[][])
    {
	int m=a.length;
	int n=a[0].length;	

	int u[][]=new int[m][m];
	int s[][]=new int[m][n];

	int i0,tmp;
	int z,sigma,nonzero;
	
	for(int i=0;i<m;i++)
	    for(int j=0;j<m;j++)
		{
		    if(i==j)
			u[i][j]=1;
		    else
			u[i][j]=0;
		}

	for(int i=0;i<m;i++)
	    for(int j=0;j<n;j++)
		s[i][j]=a[i][j];
	i0=-1;
	
	for(int j=0;j<n;j++)
	    {
		nonzero=0;
		for(int i=i0+1;i<m;i++)
		    if(MathTips.signum(s[i][j])!=0)
			nonzero++;

		if(nonzero!=0)
		    {
			i0++;
			for(int i=m-1;i>i0;i--)
			    {
				while(MathTips.signum(s[i][j])!=0)
				    {
					sigma = MathTips.signum(s[i][j])*MathTips.signum(s[i-1][j]);
					z=Math.abs(s[i-1][j])/Math.abs(s[i][j]);
					for(int k=0;k<n;k++)
					    s[i-1][k]-=sigma*z*s[i][k];
					for(int k=0;k<m;k++)
					    u[i-1][k]-=sigma*z*u[i][k];				   
					for(int k=0;k<n;k++)
					    {
						tmp = s[i-1][k];						
						s[i-1][k] = s[i][k];
						s[i][k]=tmp;
					    }
					for(int k=0;k<m;k++)
					    {
						tmp = u[i-1][k];
						u[i-1][k]= u[i][k];
						u[i][k]= tmp;
					    }
				    }
			    }			
		    }
	    }
	return u;
    }

    public static int[][] getEchelonMatrix(int a[][])
    {
	int m=a.length;
	int n=a[0].length;	

	int u[][]=new int[m][m];
	int s[][]=new int[m][n];

	int i0,tmp;
	int z,sigma,nonzero;
	
	for(int i=0;i<m;i++)
	    for(int j=0;j<m;j++)
		{
		    if(i==j)
			u[i][j]=1;
		    else
			u[i][j]=0;
		}

	for(int i=0;i<m;i++)
	    for(int j=0;j<n;j++)
		s[i][j]=a[i][j];
	i0=-1;
	
	for(int j=0;j<n;j++)
	    {
		nonzero=0;
		for(int i=i0+1;i<m;i++)
		    if(MathTips.signum(s[i][j])!=0)
			nonzero++;

		if(nonzero!=0)
		    {
			i0++;
			for(int i=m-1;i>i0;i--)
			    {
				while(MathTips.signum(s[i][j])!=0)
				    {
					sigma = MathTips.signum(s[i][j])*MathTips.signum(s[i-1][j]);
					z=Math.abs(s[i-1][j])/Math.abs(s[i][j]);
					for(int k=0;k<n;k++)
					    s[i-1][k]-=sigma*z*s[i][k];
					for(int k=0;k<m;k++)
					    u[i-1][k]-=sigma*z*u[i][k];				   
					for(int k=0;k<n;k++)
					    {
						tmp = s[i-1][k];						
						s[i-1][k] = s[i][k];
						s[i][k]=tmp;
					    }
					for(int k=0;k<m;k++)
					    {
						tmp = u[i-1][k];
						u[i-1][k]= u[i][k];
						u[i][k]= tmp;
					    }
				    }
			    }			
		    }
	    }
	return s;
    }

    public static boolean gcdTest(int s[][],int c[])
    {
	int tmp;
	int m=s.length;
	int n=s[0].length;
	int t[]=new int[m];
	boolean check =true;

	int rank = MathTips.getRank(s);

	for(int i=0;i<m;i++)
	    t[i]=0;

	for(int i=0;i<rank;i++)
	    {
		tmp=c[i];
		for(int j=0;j<i;j++)
		    tmp-=s[j][i]*t[j];
		if(s[i][i]==0 || tmp%s[i][i]!=0)
		    return false;
		else 
		    t[i]=tmp/s[i][i];
	    }
	return true;
    }

    public static int[] getParameterVector(int s[][],int c[])
    {
	int tmp;
	int m=s.length;
	int n=s[0].length;
	int t[]=new int[m];
	boolean check =true;

	int rank = MathTips.getRank(s);

	for(int i=0;i<m;i++)
	    t[i]=0;

	for(int i=0;i<rank;i++)
	    {
		tmp=c[i];
		for(int j=0;j<i;j++)
		    tmp-=s[j][i]*t[j];
		if(s[i][i]==0 || tmp%s[i][i]!=0)
		    return t;
		else 
		    t[i]=tmp/s[i][i];
	    }
	return t;
    }

    public static boolean fourierElimination(Frac t[][],Frac q[])
    {
	int r=t.length;
	int s=q.length;

	Frac tmpt[][]=new Frac[r][s];
	Frac tmpq[]=new Frac[s];

	if(r==0)
	    {
		for(int i=0;i<q.length;i++)
		    if(q[i].isNegative())
			return false;
		return true;
	    }

	int o = 0;
	
	for(int j=0;j<s;j++)
	    if(t[r-1][j].isPositive())
		{
		    for(int i=0;i<r;i++)
			tmpt[i][o]=t[i][j].copy();
		    tmpq[o]=q[j].copy();
		    o++;
		}

	int n1=o;
	for(int j=0;j<s;j++)
	    if(t[r-1][j].isNegative())
		{
		    for(int i=0;i<r;i++)
			    tmpt[i][o]=t[i][j].copy();
		    tmpq[o]=q[j].copy();
		    o++;
		}
	
	int n2=o;
	for(int j=0;j<s;j++)
	    if(t[r-1][j].isZero())
		{
		    for(int i=0;i<r;i++)
			tmpt[i][o]=t[i][j].copy();
		    tmpq[o]=q[j].copy();
		    o++;
		}

	for(int i=0;i<r-1;i++)
	    for(int j=0;j<n2;j++)
		tmpt[i][j].assign_divide(tmpt[r-1][j]);

	for(int j=0;j<n2;j++)
		tmpq[j].assign_divide(tmpt[r-1][j]);

	if(r==1)
	    {
		for(int i=n2;i<s;i++)
		    if(tmpq[i].isNegative())
			return false;
		
		Frac br=new Frac();
		Frac Br=new Frac();
		
		Frac maxValue=new Frac(Integer.MIN_VALUE/3);
		Frac minValue=new Frac(Integer.MAX_VALUE/3);

		if(n2>n1)
		    {
			for(int i=n1;i<n2;i++)
			    maxValue=maxValue.max(tmpq[i]);
			br=maxValue;
		    }

		if(n1>0)
		    {
			for(int i=0;i<n1;i++)
			    minValue=minValue.min(tmpq[i]);
			Br=minValue;
		    }

		if(br.subtract(Br).isPositive())
		    return false;
		else
		    return true;
	    }

	int sdash=s-n2+n1*(n2-n1);
	
	if(sdash>0)
	    {
		Frac tn[][]=new Frac[r-1][sdash];
		Frac qn[]=new Frac[sdash];

		int m=0;
		
		for(int k=0;k<n1;k++)
		    for(int l=n1;l<n2;l++)
			{
			    for(int i=0;i<r-1;i++)
				tn[i][m]=tmpt[i][k].subtract(tmpt[i][l]);
			    qn[m]=tmpq[k].subtract(tmpq[l]);
			    m++;
			}

		for(int j=n2;j<s;j++)
		    {
			for(int i=0;i<r-1;i++)
			    tn[i][m]=tmpt[i][j];
			qn[m]=tmpq[j];
			m++;			
		    }

		return MathTips.fourierElimination(tn,qn);		
	    }
	else
	    return true;
    }

    public static int[][] unitMatrix(int i)
    {
	int m[][] = new int[i][i];
	for(int j=0;j<i;j++)
	    for(int k=0;k<i;k++)
		m[j][k]=(j==k?1:0);
	return m;
    }

    public static int[][] getInvUnitMatrix(int i)
    {
	int m[][] = new int[i][i];
	for(int j=0;j<i;j++)
	    for(int k=0;k<i;k++)
		m[j][k]=(j==k?-1:0);
	return m;
    }

    public static Frac unary_minus(Frac f)
    {
	if(MathTips.signum(f.getDenominator())==-1)
	    return new Frac(f.getNumerator(),-1*f.getDenominator());
	else
	    return new Frac(-1*f.getNumerator(),f.getDenominator());
    }

   public static int unary_minus(int i)
    {
	return -1*i;
    }

    public static int[] subtractVector(int a[],int b[])
    {
	if(a.length!=b.length)
	    {
	    System.out.println("isn't samesize");
	    return null;
	    }
	else
	    {
		int c[]=new int[a.length];
		for(int i=0;i<a.length;i++)
		    c[i]=a[i]-b[i];
		return c;
	    }
    }

    public static Frac[] subtractVector(int a[],Frac b[])
    {
	return subtractVector(createVector(a),b);
    }
    
    public static Frac[] subtractVector(Frac a[],int b[])
    {
	return subtractVector(a,createVector(b));	
    }
    
    public static Frac[] subtractVector(Frac a[],Frac b[])
    {
	if(a.length!=b.length)
	    {
	    System.out.println("isn't samesize");
	    return null;
	    }
	else
	    {
		Frac C[]=new Frac[a.length];
		for(int i=0;i<a.length;i++)
		    C[i]=a[i].subtract(b[i]);
		return C;
	    }
    }

    public static int[][] multiplyMatrix(int a[][],int b[][])
    {
	int row = a.length;
	int col = b[0].length;
	if(a[0].length!=b.length)
	    {
		System.out.println("MM Error.");
		System.exit(-1);
	    }
	
	int C[][]= new int[row][col];
	for(int i=0;i<row;i++)
	    for(int j=0;j<col;j++)
		{
		    C[i][j]=0;
		    for(int k=0;k<b.length;k++)
			C[i][j]+=a[i][k]*b[k][j];
		}
	return C;
    }

    public static int[] multiplyMatrix(int a[],int b[][])
    {
	int row = a.length;
	int col = b[0].length;
	if(a.length!=b.length)
	    {
		System.out.println("MM Error.");
		System.exit(-1);
	    }
	
	int C[]= new int[col];
	for(int i=0;i<col;i++)
	    {
		C[i]=0;
		for(int j=0;j<row;j++)
		    C[i]+=a[j]*b[j][i];
	    }
	return C;
    }

    public static int[][] diag(int a[])
    {
	int size=a.length;
	int C[][]= new int[size][size];
	for(int i=0;i<size;i++)
	    for(int j=0;j<size;j++)
		if(i==j)
		    C[i][j]=a[i];
		else
		    C[i][j]=0;
	return C;
    }

    public static Frac[] createVector(int a[])
    {
	int col = a.length;
	
	Frac C[]= new Frac[col];
	for(int i=0;i<col;i++)
	    C[i]=new Frac(a[i]);
	return C;
    }

    public static Frac[][] createMatrix(int a[][])
    {
	int row = a.length;
	int col = a[0].length;
	
	Frac C[][]= new Frac[row][col];
	for(int i=0;i<row;i++)
	    for(int j=0;j<col;j++)
		C[i][j]=new Frac(a[i][j]);
	return C;
    }

    public static Frac[][] multiplyMatrix(int a[][],Frac b[][])
    {
	return multiplyMatrix(createMatrix(a),b);
    }

    public static Frac[][] multiplyMatrix(Frac a[][],int b[][])
    {
	return multiplyMatrix(a,createMatrix(b));
    }
    
    public static Frac[][] multiplyMatrix(Frac a[][],Frac b[][])
    {
	int row = a.length;
	int col = b[0].length;
	if(a[0].length!=b.length)
	    {
		System.out.print("MM Error.\n");
		System.exit(-1);
	    }
	
	Frac C[][]= new Frac[row][col];

	for(int i=0;i<row;i++)
	    for(int j=0;j<col;j++)
		{
		    C[i][j]=new Frac(0);
		    for(int k=0;k<b.length;k++)
			C[i][j]=C[i][j].add(a[i][k].multiply(b[k][j]));
		}
	return C;
    }

    public static Frac[] multiplyMatrix(int a[],Frac b[][])
    {
	return multiplyMatrix(createVector(a),b);
    }

    public static Frac[] multiplyMatrix(Frac a[],int b[][])
    {
	return multiplyMatrix(a,createMatrix(b));
    }

    public static Frac[] multiplyMatrix(Frac a[],Frac b[][])
    {
	int row = a.length;
	int col = b[0].length;
	if(a.length!=b.length)
	    {
		System.out.println("MM Error.");
		System.exit(-1);
	    }
	Frac C[]= new Frac[col];
	for(int i=0;i<col;i++)
	    {
		C[i]=new Frac(0);
		for(int j=0;j<row;j++)
		   C[i]=C[i].add(a[j].multiply(b[j][i]));
	    }
	return C;
    }

    public static void printMatrix(String s,int M[][])
    {
	System.out.println(s);
	printMatrix(M);
    }

    public static void printMatrix(int M[][])
    {
	int row = M.length;
	int col = M[0].length;
	for(int i=0;i<row;i++)
	    {
		for(int j=0;j<col;j++)
		    System.out.print(M[i][j]+" ");
		System.out.println(" ");
	    }
		System.out.println(" ");
    }

    public static void printVector(String s,int M[])
    {
	System.out.println(s);
	printVector(M);
    }

    public static void printVector(int M[])
    {
	int row = M.length;
	for(int i=0;i<row;i++)
	    System.out.print(M[i]+" ");
	System.out.println(" ");
	System.out.println(" ");
    }

    public static void printMatrix(String s,Frac M[][])
    {
	System.out.println(s);
	printMatrix(M);
    }

    public static void printMatrix(Frac M[][])
    {
	int row = M.length;
	if(row!=0)
	    {
		int col = M[0].length;
		for(int i=0;i<row;i++)
		    {
			for(int j=0;j<col;j++)
			    M[i][j].print();
			System.out.print("\n");
		    }
	System.out.print("\n");
	    }
    }

    public static void printVector(String s,Frac M[])
    {
	System.out.println(s);
	printVector(M);
    }

    public static void printVector(Frac M[])
    {
	int row = M.length;
	for(int i=0;i<row;i++)
	    M[i].print();
	System.out.print("\n\n");
    }

}
