<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>
  <xsl:strip-space elements="*"/>

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="analysis_results">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="block">
    <xsl:if test="count(inhibition/factor)+count(warning/factor)+count(directive/openmp)!=0">
    <xsl:value-of select="@source"/>	
		<xsl:text>:</xsl:text>
    <xsl:value-of select="./@lineno"/>
		<xsl:text>:</xsl:text>	    
<xsl:text>In </xsl:text>
    <xsl:value-of select="@type"/>
    <xsl:text> Block</xsl:text> 
    <xsl:if test="count(inhibition/factor)+count(warning/factor)+count(directive/openmp)!=0">
      <xsl:text>(</xsl:text>
      </xsl:if>
      <xsl:if test="count(inhibition/factor)!=0">
        <xsl:text>inhibition factor:</xsl:text>
        <xsl:value-of select="count(inhibition/factor)"/>
        <xsl:if test="count(warning/factor)+count(directive/openmp)!=0">
          <xsl:text>,</xsl:text>
        </xsl:if>        
      </xsl:if>
      <xsl:if test="count(warning/factor)!=0">
        <xsl:text>warning:</xsl:text>
        <xsl:value-of select="count(warning/factor)"/>
         <xsl:if test="count(directive/openmp)!=0">
          <xsl:text>,</xsl:text>
        </xsl:if>        
      </xsl:if>
        <xsl:if test="count(directive/openmp)!=0">
          <xsl:text>directive:</xsl:text>
          <xsl:value-of select="count(directive/openmp)"/>        
        </xsl:if>        
      <xsl:if test="count(inhibition/factor)+count(warning/factor)+count(directive/openmp)!=0 ">
        <xsl:text>)</xsl:text>
      </xsl:if>
      <xsl:text>&#xA;</xsl:text>
      <xsl:if test="count(inhibition/factor)!=0">
        <xsl:apply-templates select="./inhibition"/>
      </xsl:if>
      <xsl:if test="count(warning/factor)!=0">
        <xsl:apply-templates select="./warning"/>
      </xsl:if>
      <xsl:if test="count(directive/openmp)!=0">
        <xsl:apply-templates select="./directive"/>
      </xsl:if>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="inhibition">
    <xsl:text>Parallelization inhibition factor:&#xA;</xsl:text>
    <xsl:apply-templates select="factor"/>
  </xsl:template>

  <xsl:template match="warning">
    <xsl:text>Warning:&#xA;</xsl:text>
    <xsl:apply-templates select="factor"/>
  </xsl:template>

  <xsl:template match="factor">
    <xsl:value-of select="./data[1]/@source"/>
    <xsl:text>:</xsl:text>
    <xsl:apply-templates select="./data/@lineno">
      <xsl:sort select="@lineno"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="./data/@name">
      <xsl:sort select="@lineno"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="./line[@no]">
      <xsl:sort select="@no"/>
    </xsl:apply-templates>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="@reason"/>
    <xsl:if test="count(@detail)!=0">
      <xsl:text>(</xsl:text>
      <xsl:value-of select="@detail"/>
      <xsl:text>)</xsl:text>
    </xsl:if>
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template match="directive">
    <xsl:text>Directive:&#xA;</xsl:text>    
    <xsl:apply-templates select="openmp"/>
  </xsl:template>

  <xsl:template match="directive/openmp">
    <xsl:value-of select="./line/@source"/>
    <xsl:text>:</xsl:text>
    <xsl:apply-templates select="./line[@no]">
      <xsl:sort select="./line[@no]"/>
    </xsl:apply-templates>
    <xsl:text>#pragma omp </xsl:text>
    <xsl:value-of select="@type"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="clause"/>
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template match="clause">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="directive/openmp/clause/private">
    <xsl:value-of select="@type"/><xsl:text>(</xsl:text>
    <xsl:apply-templates select="id"/>
    <xsl:text>) </xsl:text>
  </xsl:template> 

  <xsl:template match="directive/openmp/clause/reduction">
    <xsl:text>reduction(</xsl:text>
    <xsl:value-of select="./@op"/>
    <xsl:text>:</xsl:text>   
    <xsl:apply-templates select="id"/>
    <xsl:text>) </xsl:text>
  </xsl:template> 

  <xsl:template match="id">
    <xsl:value-of select="@name"/>
    <xsl:if test="position()!=last()"> <xsl:text>,</xsl:text></xsl:if>
  </xsl:template>
  
  <xsl:template match="line[@no]">
    <xsl:value-of select="@no"/>
    <xsl:text>:</xsl:text>
  </xsl:template>

  <xsl:template match="data/@lineno">
    <xsl:text></xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>:</xsl:text>
  </xsl:template>

  <xsl:template match="data/@name">
    <xsl:value-of select="../@type"/>
    <xsl:text>'</xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>'</xsl:text>
    <xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
  </xsl:template>

  
</xsl:stylesheet>
