package com.snail.msglet;

import java.util.Collection;
import java.util.Map;


/**
 * Mailetへの処理依頼.
 * @author kagyuu
 */
public class Request {
  /**
   * 送信者 .
   */
  private User sender;

  /**
   * IPMsg上にいるユーザの一覧.
   */
  private Map<String, User> memberMap;

  /**
   * 起動しているMsgletの一覧.
   * <pre>
   * 直接、継承したRequestに見せない。
   * req.getRequestDispatcher("XXMsglet").forward(req,res)
   * で使う。
   * </pre>
   */
  private Map<String, Msglet> msgletMap;

  /**
   * 受信メッセージ.
   */
  private String msg;

  /**
   * 封書形式かどうか.
   */
  private boolean lock;

  /**
   * Creates a new Request object.
   *
   * @param pSender 送信者
   * @param pMsg メッセージ
   * @param pLock 封書形式かどうか
   * @param pMemberMap IPMsg上にいるユーザの一覧
   * @param pMsgletMap 起動しているMsgletの一覧
   */
  public Request(
    final User pSender,
    final String pMsg,
    final boolean pLock,
    final Map<String, User> pMemberMap,
    final Map<String, Msglet> pMsgletMap) {
    this.sender = pSender;
    this.msg = pMsg;
    this.lock = pLock;
    this.memberMap = pMemberMap;
    this.msgletMap = pMsgletMap;
  }

  /**
   * get lock.
   * @return lock
   */
  public final boolean isLock() {
    return lock;
  }

  /**
   * set lock.
   * @param lock lock
   */
  public final void setLock(final boolean lock) {
    this.lock = lock;
  }

  /**
   * get memberMap.
   * @return memberMap
   */
  public final Map<String, User> getMemberMap() {
    return memberMap;
  }

  /**
   * set memberMap.
   * @param memberMap memberMap
   */
  public final void setMemberMap(final Map<String, User> memberMap) {
    this.memberMap = memberMap;
  }

  /**
   * get msg.
   * @return msg
   */
  public final String getMsg() {
    return msg;
  }

  /**
   * set msg.
   * @param msg msg
   */
  public final void setMsg(final String msg) {
    this.msg = msg;
  }

  /**
   * get sender.
   * @return sender
   */
  public final User getSender() {
    return sender;
  }

  /**
   * set sender.
   * @param sender sender
   */
  public final void setSender(final User sender) {
    this.sender = sender;
  }

  /**
   * get session.
   * @return session
   */
  public final Map<String, Object> getSession() {
    return sender.getSession();
  }

  /**
   * 引数 msgletName で指定された Msglet を返します .
   * <pre>
   * 同時に、現在実行中の Msglet を msgletName に変更します。
   * </pre>
   * @param msgletName Msglet名
   * @return 引数 msgletName で指定された Msglet
   */
  public final Msglet getRequestDispatcher(final String msgletName) {
    sender.setCurrentMsgletName(msgletName);

    return msgletMap.get(msgletName);
  }

  /**
   * 現在稼働しているMsgletの一覧を返します .
   * @return 現在稼働しているMsgletの一覧
   */
  public final Collection<String> getMsgletNames() {
    return msgletMap.keySet();
  }
}
