package com.snail.msglet;

import java.util.HashMap;
import java.util.Map;


/**
 * IPMsgのクライアント情報を格納するBean.
 *
 * @author kagyuu
 */
public class User {
  /**
   * クライアントIPMsgのホスト名 .
   */
  private String host;

  /**
   * クライアントIPMsgのニックネーム .
   */
  private String nickName;

  /**
   * クライアントIPMsgのグループ .
   */
  private String group;

  /**
   * クライアントIPMsgのアドレス .
   */
  private String addr;

  /**
   * クライアントIPMsgの状態（欠席） .
   */
  private int absence;

  /**
   * クライアントIPMsgの実行中Msglet .
   */
  private String currentMsgletName = null;

  /**
   * クライアントIPMsgのセション情報 .
   */
  private Map<String, Object> session = new HashMap<String, Object>();

  /**
   * Creates a new User object.
   *
   * @param pHost ホスト名
   * @param pNickName ニックネーム
   * @param pGroup グループ名
   * @param pAddr IPアドレス
   * @param pAbsence 欠席状態フラグ
   */
  public User(
    final String pHost,
    final String pNickName,
    final String pGroup,
    final String pAddr,
    final int pAbsence) {
    this.host = pHost;
    this.nickName = pNickName;
    this.group = pGroup;
    this.addr = pAddr;
    this.absence = pAbsence;
  }

  /**
   * get absence.
   * @return absence
   */
  public final int getAbsence() {
    return absence;
  }

  /**
   * set absence.
   * @param absence absence
   */
  public final void setAbsence(final int absence) {
    this.absence = absence;
  }

  /**
   * get addr.
   * @return addr
   */
  public final String getAddr() {
    return addr;
  }

  /**
   * set addr.
   * @param addr addr
   */
  public final void setAddr(final String addr) {
    this.addr = addr;
  }

  /**
   * get currentMsgletName.
   * @return currentMsgletName
   */
  public final String getCurrentMsgletName() {
    return currentMsgletName;
  }

  /**
   * set currentMsgletName.
   * @param currentMsgletName currentMsgletName
   */
  public final void setCurrentMsgletName(final String currentMsgletName) {
    this.currentMsgletName = currentMsgletName;
  }

  /**
   * get group.
   * @return group
   */
  public final String getGroup() {
    return group;
  }

  /**
   * set group.
   * @param group group
   */
  public final void setGroup(final String group) {
    this.group = group;
  }

  /**
   * get host.
   * @return host
   */
  public final String getHost() {
    return host;
  }

  /**
   * set host.
   * @param host host
   */
  public final void setHost(final String host) {
    this.host = host;
  }

  /**
   * get nickName.
   * @return nickName
   */
  public final String getNickName() {
    return nickName;
  }

  /**
   * set nickName.
   * @param nickName nickName
   */
  public final void setNickName(final String nickName) {
    this.nickName = nickName;
  }

  /**
   * get session.
   * @return session
   */
  final Map<String, Object> getSession() {
    return session;
  }

  /**
   * set session.
   * @param session session
   */
  final void setSession(final Map<String, Object> session) {
    this.session = session;
  }
}
