#!/bin/sh
# Wake-On-LAN frontend program
# Copyright 2007 IPnuts Extension.
# Licensed under GPL version 2

LISTFILE=/etc/hosts.wol

## check reg or send or del or normal
if echo $QUERY_STRING | grep MAC; then
	REG=1
	SEND=0
	DEL=0
	if echo $QUERY_STRING | grep 'NAME=&'; then
		BADNAME=1
		BADMAC=0
	else
		if echo $QUERY_STRING | sed -e 's/.*MAC=//' | grep '%3A'; then
			echo $QUERY_STRING | sed -e 's/HOSTNAME=//g' -e 's/&MAC//' -e 's/%3A/\:/g' >> $LISTFILE
			BADNAME=0
			BADMAC=0
		else
			BADNAME=0
			BADMAC=1
		fi
	fi
elif echo $QUERY_STRING | grep SENDHOST; then
	REG=0
	SEND=1
	DEL=0
elif echo $QUERY_STRING | grep DELHOST; then
	grep -v `echo $QUERY_STRING | sed -e 's/DELHOST=//' -e 's/%3D/=/' -e 's/%3A/:/g'` $LISTFILE > /tmp/tmphostlist
	rm $LISTFILE
	mv /tmp/tmphostlist $LISTFILE
	DEL=1
	REG=0
	SEND=0
else
	DEL=0
	REG=0
	SEND=0
fi

## check list
## If FILELIST is 0 byte, delete FILELIST.
if [ ! -s $LISTFILE ]; then
	rm $LISTFILE
fi

## load host list
LIST=`cat $LISTFILE`

## main HTML
cat <<EOF
Content-type: text/html; charset=EUC-JP
Pragma: no-cache

<HTML>
	<HEAD>
		<TITLE>Wake-On-LAN</TITLE>
	</HEAD>
	<BODY bgcolor="#A1D0FF">
		<H2>Wake-On-LANѥåȤ</H2>
		<HR>
		<H3>ۥȤϿ</H3>
EOF

## if REG
if [ $REG = 1 ]; then
	if [ $BADNAME = 1 ]; then
		echo "̾ޤ"
	else
		if [ $BADMAC = 1 ]; then
			echo "MACɥ쥹Ǥ"
		else
			echo "`echo $QUERY_STRING | sed -e 's/HOSTNAME=//' -e 's/&.*//'` (`echo $QUERY_STRING | sed -e 's/.*MAC=//' -e 's/%3A/:/g'`)Ͽޤ"
		fi
	fi
fi

## main HTML
cat <<EOF
		<FORM METHOD="GET" ACTION="/cgi-bin/wakeonlan.cgi">
		<TABLE border=0>
			<TR align=left>
				<TH width=200>̾(ȾѱѿΤ)</TH>
				<TH><INPUT TYPE="text" NAME="HOSTNAME"></TH>
				<TH>:Server</TH>
			</TR>
			<TR align=left>
				<TH width=200>MACɥ쥹</TH>
				<TH><INPUT TYPE="text" NAME="MAC" maxlength=17></TH>
				<TH>:00:00:00:00:00:00</TH>
			</TR>
		</TABLE>
		<INPUT TYPE="submit" VALUE="Ͽ">
		</FORM>
		<HR>
		<H3>ѥåȤ</H3>
EOF

## if SEND
if [ $SEND = 1 ]; then
	if echo $QUERY_STRING | grep nodata >> /dev/null; then
		:
	else
		SENDMAC=`echo $QUERY_STRING | sed -e 's/SENDHOST=//' -e 's/%3A/:/g'`
		echo "$SENDMAC˥ޥåѥåȤޤ<br>"
		/usr/sbin/ether-wake $SENDMAC
	fi
fi

## main HTML
cat <<EOF
		<FORM METHOD="GET" ACTION="/cgi-bin/wakeonlan.cgi">
			<DIV>
				<SELECT NAME="SENDHOST">
EOF

if [ -e $LISTFILE ]; then
	for data in $LIST
	do
		datahost=`echo $data | sed -e 's/=.*//'`
		datamac=`echo $data | sed -e 's/.*=//'`
		echo -e "\t\t\t\t\t<OPTION value=\"$datamac\">$datahost ($datamac)"
	done
else
	echo -e "\t\t\t\t\t<OPTION value=\"nodata\">ۥȤϿƤ"
fi

cat <<EOF
				</SELECT>
			</DIV>
			<INPUT TYPE="submit" value="">
		</FORM>
		<HR>
		<H3>ϿۥȤ</H3>
EOF

## if DEL
if [ $DEL = 1 ]; then
	if echo $QUERY_STRING | grep nodata >> /dev/null; then
		:
	else
		echo "`echo $QUERY_STRING | sed -e 's/DELHOST=//' -e 's/%3D.*//'`ޤ"
	fi
fi

cat <<EOF
		<FORM METHOD="GET" ACTION="/cgi-bin/wakeonlan.cgi">
			<DIV>
				<SELECT NAME="DELHOST">
EOF

if [ -e $LISTFILE ]; then
	for data in $LIST
	do
		datahost=`echo $data | sed -e 's/=.*//'`
		datamac=`echo $data | sed -e 's/.*=//'`
		echo -e "\t\t\t\t\t<OPTION value=\"$data\">$datahost ($datamac)"
	done
else
	echo -e "\t\t\t\t\t<OPTION value=\"nodata\">ۥȤϿƤ"
fi

cat <<EOF
				</SELECT>
			</DIV>
			<INPUT TYPE="submit" value="">
		</FORM>
		<HR>
		<A HREF="index.cgi">ǽ</A>
	</BODY>
</HTML>
EOF
