<?php

require_once 'strctl_class.inc';

class ArrCtl
{

	var $sp;
	var $tr;
	var $enc;

	function ArrCtl()
	{
		$this->sp = array();
		$this->sp['SJIS'] = '@';
		$this->sp['sjis'] =& $this->sp['SJIS'];
		$this->sp['Shift_JIS'] =& $this->sp['SJIS'];
		$this->sp['shift_jis'] =& $this->sp['SJIS'];
		$this->sp['SHIFT_JIS'] =& $this->sp['SJIS'];
		$this->sp['EUC'] = StrCtl::p2SJIStoEUC($this->sp['SJIS']);
		$this->sp['euc'] =& $this->sp['EUC'];
		$this->sp['EUC-JP'] =& $this->sp['EUC'];
		$this->sp['euc-jp'] =& $this->sp['EUC'];
		$this->setTrimMode(0);
		$this->setEncoding('SJIS');
	}

	function setTrimMode($trim)
	{
		$this->tr = $trim;
	}

	function setEncoding($encoding)
	{
		$this->enc = $encoding;
	}

	function blankFilter($var, $trim=NULL, $encoding=NULL)
	{
		if (!is_null($trim)) { $this->setTrimMode($trim); }
		if (!is_null($encoding)) { $this->setEncoding($encoding); }
		return array_filter($var, array($this, 'blankFilter_callback'));
	}

	function blankFilter_callback($var)
	{
		if (is_array($var)) {
			return (count($var) > 0);
		} else {
			switch ($this->tr) {
				case 2: $var = str_replace($this->sp[$this->enc], '', $var);
				case 1: $var = trim($var);
			}
			return (strlen($var) > 0);
		}
	}

	function resetKey($arr)
	{
		$tmp = array();
		foreach ($arr as $val) {
			$tmp[] = $val;
		}
		return $tmp;
	}

}

?>