<?php
// p2 - TlCLbVCuij
//      NXƂĐ݌vĂ΂悩EEEB

require_once 'datactl.inc';
require_once 'expack.inc';
require_once 'filectl_class.inc';

$cached_img_txt = $prefdir . '/p2_cached_img.txt';
$aborn_img_txt  = $prefdir . '/p2_aborn_img.txt';
$aborn_host_txt = $prefdir . '/p2_aborn_host.txt';
$icm_result = ''; //Viewerŉ摜̍폜sƂ̃bZ[Wi[

//========================================================================
// getImageCacheInfo -- 摜LbVETlC擾֐
//========================================================================
function getImageCacheInfo($img_url)
{
	global $datdir, $ic_cachedir, $ic_thumbdir, $ic_thumb_format;

	//LbVETlC̃pXݒ
	$parsed_url = parse_url($img_url);
	$dp = strrpos($parsed_url['path'], '.');
	if (!$dp) { $dp = strlen($parsed_url['path']); }
	if (substr($ic_cachedir, -1) == '/') { $ic_cachedir = substr($ic_cachedir, 0, -1); }
	if (substr($ic_thumbdir, -1) == '/') { $ic_thumbdir = substr($ic_thumbdir, 0, -1); }

	//RgcƂȂ̂ŉC}C`B
	if (!is_dir($ic_cachedir) || !is_dir($ic_thumbdir)) {
		$ddp = '|^' . preg_quote($datdir) . '|';
		if (P2_SAFE_MODE && @preg_match($ddp, $ic_cachedir) && preg_match($ddp, $ic_thumbdir)) {
			$sm_nodir = 1;
		} elseif (!FileCtl::mkdir_for($ic_cachedir.'/dummy') || !FileCtl::mkdir_for($ic_thumbdir.'/dummy')) {
			return false;
		}
	}
	
	$cache_path = $parsed_url['host'] . $parsed_url['path'];
	if ($ic_thumb_format) {
		$thumb_path = $parsed_url['host'] . substr($parsed_url['path'], 0, $dp) . '.png';
		$thumb_k_path = $parsed_url['host'] . substr($parsed_url['path'], 0, $dp) . '_k.png';
	} else {
		$thumb_path = $parsed_url['host'] . substr($parsed_url['path'], 0, $dp) . '.jpg';
		$thumb_k_path = $parsed_url['host'] . substr($parsed_url['path'], 0, $dp) . '_k.jpg';
	}
	
	if (P2_SAFE_MODE) {
		if ($sm_nodir) {
			$cache_path = $ic_cachedir . rawurlencode('/' . $cache_path);
			$thumb_path = $ic_thumbdir . rawurlencode('/' . $thumb_path);
			$thumb_k_path = $ic_thumbdir . rawurlencode('/' . $thumb_k_path);
		} else {
			$cache_path = $ic_cachedir . '/' . rawurlencode($cache_path);
			$thumb_path = $ic_thumbdir . '/' . rawurlencode($thumb_path);
			$thumb_k_path = $ic_thumbdir . '/' . rawurlencode($thumb_k_path);
		}
	} else {
		$cache_path = $ic_cachedir . '/' . $cache_path;
		$thumb_path = $ic_thumbdir . '/' . $thumb_path;
		$thumb_k_path = $ic_thumbdir . '/' . $thumb_k_path;
	}

	//܂Ƃ߂
	$cache_info = array(
		'cache_path' => $cache_path,
		'cache_size' => getImageCacheSize($cache_path),
		'cache_url' => preg_replace_callback('|[^/]+|', 'urlencode_callback', $cache_path),
		'thumb_path' => $thumb_path,
		'thumb_size' => getImageCacheSize($thumb_path),
		'thumb_url' => preg_replace_callback('|[^/]+|', 'urlencode_callback', $thumb_path),
		'thumb_k_path' => $thumb_k_path,
		'thumb_k_size' => getImageCacheSize($thumb_k_path),
		'thumb_k_url' => preg_replace_callback('|[^/]+|', 'urlencode_callback', $thumb_k_path),
	);

	return $cache_info;
}

//========================================================================
// getImageCacheSize -- 摜LbVETlC̃TCY擾֐
//========================================================================
function getImageCacheSize($path)
{
	if (file_exists($path) && ($size = @getimagesize($path)) && in_array($size[2], array(1,2,3))) {
		return array($size[0], $size[1], $size[2], $size[3], filesize($path), filemtime($path));
	} else {
		return false;
	}
}

//========================================================================
// makeThumbNail -- TlC쐬֐
//========================================================================
function makeThumbNail($org_path, $new_path)
{
	global $ktai;

	//GDCugȂƂ
	if (!extension_loaded('gd')) { return false; }
	//TlC쐬ς̂Ƃ
	if (file_exists($new_path)) { return true; }
	//IWiLbVĂȂƂ
	if (!file_exists($org_path)) { return false; }

	$size = getimagesize($org_path);

	//IWiĂƂ
	if (!$size || !in_array($size[2], array(1, 2, 3))) {
		if (file_exists($org_path)) {
			unlink($org_path);
		}
		return false;
	}

	//TlCTCY̍őlݒ
	if ($ktai) {
		global $ic_thumb_k_width, $ic_thumb_k_height, $ic_thumb_k_format, $ic_thumb_k_quality;
		$max_width   = $ic_thumb_k_width;
		$max_height  = $ic_thumb_k_height;
		$thumb_png   = $ic_thumb_k_format;
		$jpg_quality = $ic_thumb_k_quality;
	} else {
		global $ic_thumb_width, $ic_thumb_height, $ic_thumb_format, $ic_thumb_quality;
		$max_width   = $ic_thumb_width;
		$max_height  = $ic_thumb_height;
		$thumb_png   = $ic_thumb_format;
		$jpg_quality = $ic_thumb_quality;
	}

	//TlCTCYvZ
	list($width, $height) = calcThumbSize($size[0], $size[1], $max_width, $max_height);

	//_E[h摜C[W\[X쐬iőTCY菬ꍇ͂̂܂܃Rs[ďIj
	switch ($size[2]) {
		case 1: //Gif
			$org_img = imagecreatefromgif($org_path);
			break;
		case 2: //JPEG
			if (!$thumb_png && $size[0] <= $max_width && $size[1] <= $max_height) {
				copy($org_path, $new_path);
				return true;
			}
			$org_img = imagecreatefromjpeg($org_path);
			break;
		case 3: //PNG
			if ($thumb_png && $size[0] <= $max_width && $size[1] <= $max_height) {
				copy($org_path, $new_path);
				return true;
			}
			$org_img = imagecreatefrompng($org_path);
			break;
		default:
			return false;
	}
	//TlC쐬
	$new_img = imagecreatetruecolor($width, $height);
	if ($size[2] != 2) { //Gif,PNG̓At@`lꍇ̂ŗ\ߔœhԂ
		$white = imagecolorallocate($new_img, 255, 255, 255);
		imagefill($new_img, 0, 0, $white);
	}
	imagecopyresampled($new_img, $org_img, 0, 0, 0, 0, $width, $height, $size[0], $size[1]);
	imagedestroy($org_img);

	//TlCۑ
	FileCtl::mkdir_for($new_path);
	if ($thumb_png) {
		imagepng($new_img, $new_path);
	} else {
		imagejpeg($new_img, $new_path, $jpg_quality);
	}
	imagedestroy($new_img);

	return true;
}


//========================================================================
// calcThumbSize -- TlCTCYvZ֐
//========================================================================
function calcThumbSize($width, $height, $max_width, $max_height)
{
	if (($width * $max_height / $max_width) >= $height && $max_width < $width) {
		$thumb_width = $max_width;
		$thumb_height = round($max_width * $height / $width);
	} elseif ($max_height < $height && $max_height != 0) {
		$thumb_height = $max_height;
		$thumb_width = round($max_height * $width / $height);
	} else {
		$thumb_width = $width;
		$thumb_height = $height;
	}
	return array($thumb_width, $thumb_height);
}


//========================================================================
// deleteCache -- LbVETlC폜֐
//========================================================================
function deleteCache($file, $key, $action)
{
	global $list, $trim_list, $icm_result;

	$target_info = getImageCacheInfo($file);

	$target_all = array('delete_all', 'delete_dir', 'delete_host', 'aborn_this', 'aborn_dir', 'aborn_host');

	//IWi̍폜
	if ($action == 'delete_cache' || in_array($action, $target_all)) {
		$ceche_removed = deleteFile($target_info['cache_path']);
	} else {
		$ceche_removed = !file_exists($target_info['cache_path']);
	}

	//TlC̍폜
	if ($action == 'delete_thumb' || in_array($action, $target_all)) {
		$thumb_removed = deleteFile($target_info['thumb_path']);
	} else {
		$thumb_removed = !file_exists($target_info['thumb_path']);
	}

	//gїpTlC̍폜
	if ($action == 'delete_thumb_k' || in_array($action, $target_all)) {
		$thumb_k_removed = deleteFile($target_info['thumb_k_path']);
	} else {
		$thumb_k_removed = !file_exists($target_info['thumb_k_path']);
	}
	//摜ȂȂAXg珜O
	if ($ceche_removed && $thumb_removed && $thumb_k_removed) {
		$list[$key] = ''; // unset()łȂA''ɂ̂͋sɂ邽
		return true;
	} else {
		return false;
	}
}


//========================================================================
// deleteFile -- t@C폜֐
//========================================================================
function deleteFile($path)
{
	global $ic_cachedir, $ic_thumbdir, $icm_result;
	$path = realpath($path);
	if (!$path) {
		return true;
	}
	if (!file_exists($path)) {
		$icm_result .= "<br />\nE<em>{$path}</em>̓LbVĂ܂B";
		return true;
	} elseif (@unlink($path)) {
		$icm_result .= "<br />\nE<em>{$path}</em>폜܂B";
		if (dirname($path) != realpath($ic_cachedir) && dirname($path) != realpath($ic_thumbdir)) {
			deleteDir($path); //fBNg폜݂B
		}
		return true;
	} else {
		$icm_result .= "<br />\nE<b>ERROR!</b> <em>{$path}</em>폜ł܂łB";
		return false;
	}
}


//========================================================================
// deleteDir -- fBNg폜֐iʃfBNg폜݂j
//========================================================================
function deleteDir($path)
{
	if (P2_SAFE_MODE) {
		return false;
	}
	global $ic_cachedir, $ic_thumbdir, $icm_result;
	if (!is_dir($dir)) {
		$dir = dirname($path);
	}
	if (strstr($dir, (realpath($ic_cachedir) . '/')) || strstr($dir, (realpath($ic_thumbdir) . '/'))) {
		if (!P2_OS_MACOSX || !file_exists($dir.'/.DS_Store') || @unlink($dir.'/.DS_Store')) {
			$flag = true;
		} else {
			$flag = false;
		}
		if ($flag && @rmdir($dir)) {
			$icm_result .= "<br />\nEfBNg<em>{$dir}</em>폜܂B";
			deleteDir($dir); //ʃfBNg폜݂Bȉꍇ̂ݍ폜j
		}
	}
	return true;
}


//========================================================================
// urlencode_callback -- pXURLGR[hꂽ܂ނƂAɃGR[h֐
//========================================================================
function urlencode_callback($matches)
{
	if (preg_match('/%[0-9A-F]{2,}/', $matches[0])) {
		$matches[0] = rawurlencode($matches[0]);
	}
	return $matches[0];
}


//========================================================================
// urldecode_callback -- pXURLGR[hꂽ܂ނƂAfR[h֐
//========================================================================
function urldecode_callback($matches, $to='SJIS')
{
	if (preg_match('/%[0-9A-F]{2,}/', $matches[0])) {
		$matches[0] = rawurldecode($matches[0]);
		if (preg_match('|[^\w/.]|', $matches[0]) && extension_loaded('mbstring')) {
			$matches[0] = mb_convert_encoding($matches[0], $to);
		}
	}
	return $matches[0];
}


//========================================================================
// redirect_to_cache -- LbVĂ摜Ƀ_CNgăXNvgI֐
//========================================================================
function redirect_to_cache($path)
{
	/*
	global $ic_redirect;
	switch ($ic_redirect) {
	case 0:
		header('Content-Type: text/html; charset=Shift_JIS');
		echo <<<EOF
<html>
<head><title>p2ImageCache - OK</title></head>
<body>摜LbV or TlC 쐬I<br /><a href="{$path}">{$path}</a></body>
</html>
EOF;
		break;
	case 1:
		header('Location: '.$path);
		break;
	case 2:
		header('Content-type: '.get_mime_type($path));
		header('Content-Disposition: inline; filename='.basename($path));
		readfile($path);
	default:
		header('Location: '.$path);
	}
	*/
	header('Location: '.$path);
	exit;
}


//========================================================================
// error_and_exit -- HTTPG[\ăXNvgI֐
//========================================================================
function error_and_exit($url='', $code='404')
{
	$code = strval($code);
	$errmsg = array(
		'400' => 'Bad Request',
		'401' => 'Unauthorized',
		'402' => 'Payment Required',
		'403' => 'Forbidden',
		'404' => 'Not Found',
		'405' => 'Method Not Allowed',
		'406' => 'Not Acceptable',
		'407' => 'Proxy Authentication Required',
		'408' => 'Request Time-out',
		'409' => 'Conflict',
		'410' => 'Gone',
		'411' => 'Length Required',
		'412' => 'Precondition Failed',
		'413' => 'Request Entity Too Large',
		'414' => 'Request-URI Too Large',
		'415' => 'Unsupported Media Type',
		'500' => 'Internal Server Error',
		'501' => 'Not Implemented',
		'502' => 'Bad Gateway',
		'503' => 'Service Unavailable',
		'504' => 'Gateway Time-out',
		'505' => 'HTTP Version not supported'
	);
	if (array_key_exists($code, $errmsg)) {
		header('Content-Type: text/html', true, $code);
	}
	echo <<<EOF
<html>
<head><title>p2ImageCache - {$code} {$errmsg[$code]}</title></head>
<body><h1>{$code} {$errmsg[$code]}</h1><p>{$url}</p></body>
</html>
EOF;
	exit();
}

//========================================================================
// get_mime_type() -- gqMIME^Cv𔻕ʂ֐ismj
//========================================================================
function get_mime_type($filename)
{
	$ext = strtolower(strrchr($filename, '.'));
	switch ($ext) {
	case '.jpg':
	case '.jpeg':
		return 'image/jpeg';
	case '.gif':
		return 'image/gif';
	case '.png':
		return 'image/png';
	case '.bmp':
		return 'image/bmp';
	case '.swf':
		return 'application/x-shockwave-flash';
	default:
		return 'application/octet-stream';
	}
}

?>
