<?php
// p2 - RSSp[T

require_once 'XML/RSS.php'; //PEAR::XML_RSS

if (extension_loaded('mbstring')) {
	$enc_converter = 'mb_convert_encoding';
} else {
	require_once 'jcode_wrapper.php'; //Jcodegmb_convert_encoding݊bp[֐
	$enc_converter = 'jcode_convert_encoding';   //i{GR[fBÔ݁j
}


//============================================================
// RSS_E[hp[X֐
//============================================================

function p2GetRSS($xml)
{
	global $datdir, $_info_msg_ht, $enc_converter, $rss_check_interval;

	//RSSURI烍[Jɕۑt@C̃pXݒ
	$remotefile = parse_url($xml);
	$localfile = 'p2_rss/' . $remotefile['host'];
	$localfile .= '/' . preg_replace('/[^\w.]/', '_', substr($remotefile['path'], 1));
	if ($remotefile['query']) {
		$localfile .= '_' . preg_replace('/[^\w.]/', '_', $remotefile['query']) . '.rdf';
	}
	if (!P2_SAFE_MODE) {
		$localfile = $datdir . '/' . $localfile;
	} else {
		$localfile = $datdir . '/' . rawurlencode($localfile);
	}
	//gq.cgi.phpŕۑ̂h
	if (!preg_match('/\.(rdf|rss|xml)$/i', $localfile)) {
		//Âo[WŎ擾RSS폜
		if (file_exists($localfile)) {
			@unlink($localfile);
		}
		//gq.rdft
		$localfile .= '.rdf';
	}

	//ۑpfBNgȂ΂
	if (!is_dir(dirname($localfile))) {
		require_once './filectl_class.inc' ;
		FileCtl::mkdir_for($localfile);
	}

	//If-Modified-SinceŃ_E[hit@CAÂA[ĥƂj
	if (!file_exists($localfile) || filemtime($localfile) < (time() - ($rss_check_interval * 60)) || !empty($_GET['refresh'])) {
		require_once './datactl.inc';
		$dl = fileDownload($xml, $localfile);
		unset($dl);
	}

	//RSSp[Xi_E[hɎsȂ$_info_msg_ht͋j
	if (!$_info_msg_ht) {
		$rss =& new XML_RSS($localfile);
		if (PEAR::isError($rss)) {
			$_info_msg_ht = '<p>p2 error: ' . $rss->getMessage() . '</p>';
			return false;
		}
		$result = $rss->parse();
		if (PEAR::isError($result)) {
			$_info_msg_ht = '<p>p2 error: ' . $result->getMessage() . '</p>';
			return false;
		}
		return $rss;
	} else {
		return false;
	}

}


//===================================================================
// RSSitemvfɔCӂ̎qvf邩ǂ`FbN֐
//===================================================================
function rss_item_exists(&$items, $element)
{
	foreach ($items as $item) {
		if (isset($item[$element])) {
			return true;
		}
	}
	return false;
}


//============================================================
// ċAIR[hϊ֐
//============================================================

//UTF-8Shift_JIS
function r_utf8_to_sjis($var)
{
	global $enc_converter;
	if (is_array($var)) {
		$var = array_map('r_utf8_to_sjis', $var);
	} elseif (is_string($var)) {
		$var = $enc_converter($var, 'SJIS', 'UTF-8');
	}
	return $var;
}

//EUC-JPShift_JIS
function r_euc_to_sjis($var)
{
	global $enc_converter;
	if (is_array($var)) {
		$var = array_map('r_euc_to_sjis', $var);
	} elseif (is_string($var)) {
		$var = $enc_converter($var, 'SJIS', 'EUC-JP');
	}
	return $var;
}

//R[h肵Shift_JISɕϊ֐ɓn
function r_to_sjis($var)
{
	$checker = serialize($var);
	if (extension_loaded('mbstring')) {
		$encoding = mb_detect_encoding($checker);
		unset($checker);
		if (stristr($encoding, 'utf')) {
			$var = r_utf8_to_sjis($var);
		} elseif (stristr($encoding, 'euc')) {
			$var = r_euc_to_sjis($var);
		}
	} else {
		$encoding = AutoDetect($checker);
		unset($checker);
		if ($encoding == 4) {
			$var = r_utf8_to_sjis($var);
		} elseif ($encoding == 1) {
			$var = r_euc_to_sjis($var);
		}
	}
	return $var;
}

?>