<?php
// p2 - StrCtl -- 񑀍NX

// ݒ

if (!extension_loaded('mbstring')) {
	include_once 'includes/jcode_wrapper.php';
} elseif (phpversion() >= '4.2.0' && function_exists('mb_eregi') && function_exists('mb_eregi_replace')) {
	if ($flex_mbreg) {
		mb_regex_encoding('SJIS');
		$flex_utf8 = 0;
	}
} else {
	$flex_mbreg = 0;
}

if ($flex_ignore) {
	$preg_modifier = 'i';
} else {
	$preg_modifier = '';
}
if (phpversion() >= '4.1.0' && $flex_utf8) {
	$preg_modifier .= 'u';
}


class StrCtl{

	function p2SJIStoEUC($str){
		if(extension_loaded('mbstring')){
			$str = mb_convert_encoding($str, 'EUC-JP', 'SJIS');
		}else{
			$str = jcode_convert_encoding($str, 'EUC-JP', 'SJIS');
		}
		return $str;
	}

	function p2EUCtoSJIS($str){
		if(extension_loaded('mbstring')){
			$str = mb_convert_encoding($str, 'SJIS', 'EUC-JP');
		}else{
			$str = jcode_convert_encoding($str, 'SJIS', 'EUC-JP');
		}
		return $str;
	}

	function p2SJIStoUTF($str){
		if(extension_loaded('mbstring')){
			$str = mb_convert_encoding($str, 'UTF-8', 'SJIS');
		}else{
			$str = jcode_convert_encoding($str, 'UTF-8', 'SJIS');
		}
		return $str;
	}

	function p2UTFtoSJIS($str){
		if(extension_loaded('mbstring')){
			$str = mb_convert_encoding($str, 'SJIS', 'UTF-8');
		}else{
			$str = jcode_convert_encoding($str, 'SJIS', 'UTF-8');
		}
		return $str;
	}

	//============================================================
	// wordForMatch -- tH[瑗Ă[h}b`֐ɓK郁\bh
	//============================================================
	function wordForMatch($word, $method=''){
		global $flex_mbreg, $flex_utf8;
		$word_fm = trim($word);
		$word_fm = htmlspecialchars($word_fm, ENT_NOQUOTES);
		if (in_array($method, array('and', 'or', 'just'))) {
			if ($method != 'just') { $word_fm = str_replace('@', ' ', $word_fm); }
			$word_fm = StrCtl::p2SJIStoEUC($word_fm); //quotemeta()2oCgڂ5B("[")"["ȂǂЂ邽
			$word_fm = quotemeta($word_fm);
			$word_fm = str_replace(array('{','|','}'), array('\{','\|','\}'), $word_fm);
			if ($flex_mbreg) {
				$word_fm = StrCtl::p2EUCtoSJIS($word_fm);
			} else {
				$word_fm = str_replace('/', '\/', $word_fm);
				if ($flex_utf8) {
					$word_fm = StrCtl::p2EUCtoSJIS($word_fm);
					$word_fm = StrCtl::p2SJIStoUTF($word_fm);
				}
			}
		} else {
			//$word = str_replace('@', '|', $word);
			if (!$flex_mbreg) {
				$word_fm = str_replace('/', '\/', $word_fm);
				if ($flex_utf8) {
					$word_fm = StrCtl::p2SJIStoUTF($word_fm);
				} else {
					$word_fm = StrCtl::p2SJIStoEUC($word_fm);
				}
			}
			//$word_fm = str_replace(' ', '|', $word_fm); //ʓIȌwɍ킹
		}
		return $word_fm;
	}

	//============================================================
	// msgForMatch -- Ώە}b`֐ɓK郁\bh
	//============================================================
	function msgForMatch($msg) {
		global $flex_mbreg, $flex_utf8;
		if (!$flex_mbreg) {
			if ($flex_utf8) {
				$msg = StrCtl::p2SJIStoUTF($msg);
			} else {
				$msg = StrCtl::p2SJIStoEUC($msg);
			}
		}
		return $msg;
	}

	//============================================================
	// msgFromMatch -- ΏەVtgJISɖ߂\bh
	//============================================================
	function msgFromMatch($msg) {
		global $flex_mbreg, $flex_utf8;
		if (!$flex_mbreg) {
			if ($flex_utf8) {
				$msg = StrCtl::p2UTFtoSJIS($msg);
			} else {
				$msg = StrCtl::p2EUCtoSJIS($msg);
			}
		}
		return $msg;
	}

	//============================================================
	// filterMatch -- }`oCgΉ̐K\}b`\bh
	//============================================================
	function filterMatch($pattern, &$target) {
		global $flex_ignore, $flex_mbreg, $preg_modifier;
		if ($flex_mbreg) {
			if ($flex_ignore) {
				$result = @mb_eregi($pattern, $target);
			} else {
				$result = @mb_ereg($pattern, $target);
			}
		} else {
			$result = @preg_match("/{$pattern}/{$preg_modifier}", $target);
		}
		return $result;
	}

	//============================================================
	// filterReplace -- }`oCgΉ̐K\u\bh
	//============================================================
	function filterReplace($pattern, $replace, $target) {
		global $flex_ignore, $flex_mbreg, $preg_modifier;
		if ($flex_mbreg) {
			if ($flex_ignore) {
				$result = @mb_eregi_replace($pattern, $replace, $target);
			} else {
				$result = @mb_ereg_replace($pattern, $replace, $target);
			}
		} else {
			$result = @preg_replace("/{$pattern}/{$preg_modifier}", $replace, $target);
		}
		return $result;
	}

}

?>