﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Editor
{
    class IronPythonEngine : IEngine
    {
        StringBuilder _commadLine = new StringBuilder();
        ITextOutout _textOutput;
        IronPython.Hosting.PythonEngine _engine ;
        EventMemoryStream ms = new EventMemoryStream();

        internal IronPythonEngine(IronPython.Hosting.PythonEngine engine)
        {
            _engine = engine;

            string path = System.Reflection.Assembly.GetExecutingAssembly().Location;

            _engine.AddToPath(Path.GetDirectoryName(path));
            _engine.AddToPath(Path.Combine(Path.GetDirectoryName(path), "Lib"));
            _engine.Sys.executable = path;
            _engine.Sys.prefix = Path.GetDirectoryName(path);

            ms.Wrote += new EventHandler(ms_Wrote);

        }

        public void Execute(string input)
        {
            _commadLine.Append(input + "\n");
            bool isExecPython;
            try
            {
                isExecPython = _engine.ParseInteractiveInput(_commadLine.ToString(), input.Length != 0);
            }
            catch
            {
                isExecPython = true;
            }
            if (!isExecPython)
            {
                AppendResult(input + "\r\n... ");
                return;
            }

            string output = "";
            AppendResult(input + "\r\n");

            try
            {
                ms.Position = 0;
                _engine.SetStandardOutput(ms);
                _engine.ExecuteToConsole(_commadLine.ToString());
            }
            catch (Exception ex)
            {
                if (output == "")
                {
                    output = ex.Message;
                }
            }
            AppendResult(output + "\r\n");
            _commadLine.Length = 0;
            AppendResult(">>> ");
        }
        public void SetTextOutput(ITextOutout textOutput)
        {
            _textOutput = textOutput;
        }
        private void AppendResult(string text)
        {
            StreamWriter sw = new StreamWriter(ms, Encoding.Default);
            sw.Write(text);
            sw.Flush();
        }
        void ms_Wrote(object sender, EventArgs e)
        {
            ms.Position = 0;
            StreamReader sr = new StreamReader(ms, Encoding.Default, false);
            string output = sr.ReadToEnd();
            ms.SetLength(0);

            _textOutput.OutputText(output);
        }
    }
}
