﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor
{
    public class IronPythonTextBoxBuilder
    {
        public IHelpWindow HelpWindow { get; set; }
        public IIntelisenceWindow IntelisenceWindow { get; set; }
        public IPythonParser PythonParser { get; set; }
        public IPythonTextBox PytohnTextBox { get; set; }
        public IIntelisenceDictionary IntelisenceDictionary { get; set; }
        public ITextOutout TextOutput { get; set; }
        public IEngine Engine { get; set; }

        public void Bind()
        {
            IronPython.Hosting.PythonEngine engine = null;
            if (Engine == null)
            {
                if (engine == null)
                {
                    engine = new IronPython.Hosting.PythonEngine();
                }

                Engine = new IronPythonEngine(engine);
            }
            if (TextOutput == null)
            {
                TextOutput = new DefaultWindow.NullTextOutput();
            }
            if (IntelisenceWindow == null)
            {
                IntelisenceWindow = new DefaultWindow.NullIntelisence();
            }
            if (HelpWindow == null)
            {
                HelpWindow = new DefaultWindow.NullHelp();
            }
            if (PytohnTextBox == null)
            {
                PytohnTextBox = new DefaultWindow.NullTextBox();
            }
            if (IntelisenceDictionary == null)
            {
                if (engine == null)
                {
                    engine = new IronPython.Hosting.PythonEngine();
                }
                IntelisenceDictionary = new Editor.Parser.PythonDictionary(engine);
                //IntelisenceDictionary = new Editor.DefaultParser.IronPythonDefaultDictionary(engine);
            }
            if (PythonParser == null)
            {
                PythonParser = new Editor.Parser.PythonParser();
                //PythonParser = new DefaultParser.PyParser(IntelisenceDictionary);
            }

            IntelisenceController intelisenceController = new IntelisenceController();
            HelpController helpController = new HelpController();
            PythonTextBoxController textBoxController = new PythonTextBoxController(PytohnTextBox, TextOutput);

            intelisenceController.Injection(IntelisenceWindow);
            intelisenceController.Visible = false;

            helpController.Injection(HelpWindow);
            helpController.Visible = false;

            IntelisenceCore core = new IntelisenceCore(IntelisenceDictionary, textBoxController, helpController, intelisenceController, Engine, TextOutput, PythonParser);
        }
    }
}
