// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"

using System;

namespace Editor.Parser.IronPythonParser
{
    class InternalParser
    {
        private int yacc_verbose_flag = 0;

#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected static  int yyFinal = 13;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static  string [] yyRule = {
//t    "$accept : Prog",
//t    "Prog : expression_list",
//t    "expression_list : expression",
//t    "expression_list : expression_list2 expression",
//t    "expression_list2 : expression_list comma",
//t    "old_expression_list : old_expression",
//t    "old_expression_list : old_expression_list comma old_expression",
//t    "expression : conditional_expression",
//t    "expression : lambda_form",
//t    "old_expression : or_test",
//t    "old_expression : old_lambda_form",
//t    "conditional_expression : or_test",
//t    "conditional_expression : or_test reserved_if or_test reserved_else expression",
//t    "lambda_form : reserved_lambda colon expression",
//t    "lambda_form : reserved_lambda parameter_list colon expression",
//t    "old_lambda_form : reserved_lambda colon old_expression",
//t    "old_lambda_form : reserved_lambda parameter_list colon old_expression",
//t    "parameter_list : defparameter_list",
//t    "parameter_list : defparameter_list2",
//t    "parameter_list : defparameter_list comma asterisk Identifier",
//t    "parameter_list : defparameter_list comma asterisk2 Identifier",
//t    "parameter_list : defparameter_list comma asterisk Identifier comma asterisk2 Identifier",
//t    "parameter_list : asterisk Identifier",
//t    "parameter_list : asterisk Identifier comma asterisk2 Identifier",
//t    "parameter_list : asterisk2 Identifier",
//t    "defparameter_list : defparameter",
//t    "defparameter_list : defparameter_list2 defparameter",
//t    "defparameter_list2 : defparameter_list comma",
//t    "defparameter : parameter",
//t    "defparameter : parameter equal expression",
//t    "parameter : Identifier",
//t    "parameter : parenOpen sublist parenClose",
//t    "parameter : parenOpen sublist2 parenClose",
//t    "sublist : parameter",
//t    "sublist : sublist2 parameter",
//t    "sublist2 : sublist comma",
//t    "or_test : and_test",
//t    "or_test : or_test reserved_or and_test",
//t    "and_test : not_test",
//t    "and_test : and_test reserved_and not_test",
//t    "not_test : comparison",
//t    "not_test : reserved_not not_test",
//t    "comparison : or_expr",
//t    "comparison : or_expr comp_operator comparison",
//t    "comp_operator : lessThan",
//t    "comp_operator : graterThan",
//t    "comp_operator : equal2",
//t    "comp_operator : graterEqual",
//t    "comp_operator : lessEqual",
//t    "comp_operator : notEqual2",
//t    "comp_operator : notEqual",
//t    "comp_operator : reserved_is",
//t    "comp_operator : reserved_is reserved_not",
//t    "comp_operator : reserved_in",
//t    "comp_operator : reserved_not reserved_in",
//t    "or_expr : xor_expr",
//t    "or_expr : or_expr verticalBar xor_expr",
//t    "xor_expr : and_expr",
//t    "xor_expr : xor_expr caret and_expr",
//t    "and_expr : shift_expr",
//t    "and_expr : and_expr ampersand shift_expr",
//t    "shift_expr : a_expr",
//t    "shift_expr : shift_expr leftShift a_expr",
//t    "shift_expr : shift_expr rightShift a_expr",
//t    "a_expr : m_expr",
//t    "a_expr : a_expr plus m_expr",
//t    "a_expr : a_expr dash m_expr",
//t    "m_expr : u_expr",
//t    "m_expr : m_expr asterisk u_expr",
//t    "m_expr : m_expr slash u_expr",
//t    "m_expr : m_expr slash2 u_expr",
//t    "m_expr : m_expr percent u_expr",
//t    "u_expr : power",
//t    "u_expr : dash u_expr",
//t    "u_expr : plus u_expr",
//t    "u_expr : tilde u_expr",
//t    "power : primary",
//t    "power : primary asterisk2 u_expr",
//t    "primary : atom",
//t    "primary : attributeref",
//t    "primary : subscription",
//t    "primary : slicing",
//t    "primary : call",
//t    "subscription : primary bracketOpen expression_list bracketClose",
//t    "subscription : primary bracketOpen expression_list2 bracketClose",
//t    "atom : Identifier",
//t    "atom : literal",
//t    "atom : enclosure",
//t    "literal : Number",
//t    "literal : stringliteral",
//t    "attributeref : primary dot Identifier",
//t    "enclosure : parenth_form",
//t    "enclosure : list_display",
//t    "enclosure : generator_expression",
//t    "enclosure : dict_display",
//t    "enclosure : string_conversion",
//t    "parenth_form : parenOpen parenClose",
//t    "parenth_form : parenOpen expression_list parenClose",
//t    "parenth_form : parenOpen expression_list2 parenClose",
//t    "list_display : bracketOpen bracketClose",
//t    "list_display : bracketOpen expression_list bracketClose",
//t    "list_display : bracketOpen expression_list2 bracketClose",
//t    "list_display : bracketOpen expression list_for bracketClose",
//t    "list_iter : list_for",
//t    "list_iter : list_if",
//t    "list_for : reserved_for target_list reserved_in old_expression_list",
//t    "list_for : reserved_for target_list2 reserved_in old_expression_list",
//t    "list_for : reserved_for target_list reserved_in old_expression_list list_iter",
//t    "list_for : reserved_for target_list2 reserved_in old_expression_list list_iter",
//t    "list_if : reserved_if old_expression",
//t    "list_if : reserved_if old_expression list_iter",
//t    "generator_expression : parenOpen expression genexpr_for parenClose",
//t    "genexpr_for : reserved_for target_list reserved_in or_test",
//t    "genexpr_for : reserved_for target_list2 reserved_in or_test",
//t    "genexpr_for : reserved_for target_list reserved_in or_test genexpr_iter",
//t    "genexpr_for : reserved_for target_list2 reserved_in or_test genexpr_iter",
//t    "genexpr_iter : genexpr_for",
//t    "genexpr_iter : genexpr_if",
//t    "genexpr_if : reserved_if old_expression",
//t    "genexpr_if : reserved_if old_expression genexpr_iter",
//t    "target_list : target",
//t    "target_list : target_list2 target",
//t    "target_list2 : target_list comma",
//t    "target : Identifier",
//t    "target : attributeref",
//t    "target : subscription",
//t    "target : slicing",
//t    "dict_display : braceOpen braceClose",
//t    "dict_display : braceOpen key_datum_list braceClose",
//t    "dict_display : braceOpen key_datum_list2 braceClose",
//t    "key_datum_list : key_datum",
//t    "key_datum_list : key_datum_list2 key_datum",
//t    "key_datum_list2 : key_datum_list comma",
//t    "key_datum : expression colon expression",
//t    "string_conversion : backApostrophe expression_list backApostrophe",
//t    "slicing : primary bracketOpen slice_list bracketClose",
//t    "slice_list : slice_item",
//t    "slice_list : slice_list2 slice_item",
//t    "slice_list2 : slice_list comma",
//t    "slice_item : proper_slice",
//t    "slice_item : ellipsis",
//t    "proper_slice : short_slice",
//t    "proper_slice : long_slice",
//t    "short_slice : colon",
//t    "short_slice : expression colon",
//t    "short_slice : colon expression",
//t    "short_slice : expression colon expression",
//t    "long_slice : short_slice colon",
//t    "long_slice : short_slice colon expression",
//t    "ellipsis : dot3",
//t    "call : primary parenOpen parenClose",
//t    "call : primary parenOpen argument_list parenClose",
//t    "call : primary parenOpen argument_list genexpr_for parenClose",
//t    "argument_list : positional_arguments",
//t    "argument_list : positional_arguments comma keyword_arguments",
//t    "argument_list : positional_arguments comma asterisk expression",
//t    "argument_list : positional_arguments comma asterisk2 expression",
//t    "argument_list : positional_arguments comma keyword_arguments comma asterisk expression",
//t    "argument_list : positional_arguments comma keyword_arguments comma asterisk2 expression",
//t    "argument_list : positional_arguments comma asterisk expression comma asterisk2 expression",
//t    "argument_list : positional_arguments comma keyword_arguments comma asterisk expression comma asterisk2 expression",
//t    "argument_list : keyword_arguments",
//t    "argument_list : keyword_arguments comma asterisk expression",
//t    "argument_list : keyword_arguments comma asterisk2 expression",
//t    "argument_list : keyword_arguments comma asterisk expression comma asterisk2 expression",
//t    "argument_list : asterisk expression",
//t    "argument_list : asterisk expression comma asterisk2 expression",
//t    "argument_list : asterisk2 expression",
//t    "positional_arguments : expression",
//t    "positional_arguments : positional_arguments comma expression",
//t    "keyword_arguments : keyword_item",
//t    "keyword_arguments : keyword_arguments comma keyword_item",
//t    "keyword_item : Identifier equal expression",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static  string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"Number","Identifier","plus",
    "dash","asterisk","slash","tilde","parenOpen","parenClose",
    "leftShift","rightShift","asterisk2","stringliteral","dot",
    "ampersand","caret","verticalBar","lessThan","graterThan","equal2",
    "graterEqual","lessEqual","notEqual2","notEqual","reserved_is",
    "reserved_not","reserved_in","reserved_and","reserved_or","colon",
    "reserved_lambda","comma","equal","reserved_if","reserved_else",
    "bracketOpen","bracketClose","reserved_for","braceOpen","braceClose",
    "slash2","percent","powerEqual","rightShiftEqual","leftShiftEqual",
    "dot3","plusEqual","minusEqual","asteriskEqua","slashEqual",
    "percentEqual","ampersandEqual","caretEqual","verticalBarEqual",
    "backApostrophe","atSign","reserved_as","reserved_assert",
    "reserved_break","reserved_class","reserved_continue","reserved_def",
    "reserved_del","reserved_elif","reserved_except","reserved_exec",
    "reserved_finally","reserved_from","reserved_global",
    "reserved_import","reserved_pass","reserved_print","reserved_raise",
    "reserved_return","reserved_try","reserved_while","reserved_with",
    "reserved_yield",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;			// initial size
    int yyState = 0;                                   // state stack ptr
    int [] yyStates = new int[yyMax];	                // state stack 
    Object yyVal = null;                               // value stack ptr
    Object [] yyVals = new Object[yyMax];	        // value stack
    int yyToken = -1;					// current input
    int yyErrorFlag = 0;				// #tks to shift

    /*yyLoop:*/ for (int yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        int[] i = new int[yyStates.Length+yyMax];
        yyStates.CopyTo (i, 0);
        yyStates = i;
        Object[] o = new Object[yyVals.Length+yyMax];
        yyVals.CopyTo (o, 0);
        yyVals = o;
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ for (;;) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 2:
#line 46 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 3:
#line 50 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ExpressionList(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 4:
#line 57 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 5:
#line 64 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 6:
#line 68 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ExpressionList(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 7:
#line 75 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 8:
#line 79 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 9:
#line 86 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 10:
#line 90 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 11:
#line 96 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 12:
#line 100 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Trinomial(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[-4+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 13:
#line 133 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Lambda(((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 14:
#line 137 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Lambda(((IPyExpression)yyVals[0+yyTop]), ((IPyExpression)yyVals[-2+yyTop]));
		}
  break;
case 15:
#line 143 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Lambda(((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 16:
#line 147 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Lambda(((IPyExpression)yyVals[0+yyTop]), ((IPyExpression)yyVals[-2+yyTop]));
		}
  break;
case 17:
#line 154 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 18:
#line 158 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 19:
#line 162 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.ParamAster(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 20:
#line 166 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.ParamAster2(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 21:
#line 170 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[-6+yyTop]), PyExpressionFactory.ParamAster(((PyToken)yyVals[-3+yyTop])), PyExpressionFactory.ParamAster2(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 22:
#line 174 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(PyExpressionFactory.ParamAster(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 23:
#line 178 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(PyExpressionFactory.ParamAster(((PyToken)yyVals[-3+yyTop])), PyExpressionFactory.ParamAster(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 24:
#line 182 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(PyExpressionFactory.ParamAster2(((PyToken)yyVals[0+yyTop])));
		}
  break;
case 25:
#line 189 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 26:
#line 193 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParameterList(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 27:
#line 199 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 28:
#line 205 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 29:
#line 209 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParamEqual(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 30:
#line 215 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 31:
#line 219 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 32:
#line 223 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 33:
#line 229 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 34:
#line 233 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SubList(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 35:
#line 240 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 36:
#line 246 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 37:
#line 250 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.OrTest(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 38:
#line 257 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 39:
#line 261 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.AndTest(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 40:
#line 267 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 41:
#line 271 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.NotTest(((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 42:
#line 277 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 43:
#line 281 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Comparison(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 44:
#line 287 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 45:
#line 291 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 46:
#line 295 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 47:
#line 299 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 48:
#line 303 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 49:
#line 307 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 50:
#line 311 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 51:
#line 315 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 52:
#line 319 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyCompositionToken(((PyToken)yyVals[-1+yyTop]), ((PyToken)yyVals[0+yyTop]), TokenType.Composition_IsNot);
		}
  break;
case 53:
#line 323 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 54:
#line 327 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyCompositionToken(((PyToken)yyVals[-1+yyTop]), ((PyToken)yyVals[0+yyTop]), TokenType.Composition_NotIn);
		}
  break;
case 55:
#line 333 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 56:
#line 337 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.BitOR(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 57:
#line 344 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 58:
#line 348 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.BitXOR(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 59:
#line 355 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 60:
#line 359 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.BitAnd(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 61:
#line 366 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 62:
#line 370 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.LeftShift, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 63:
#line 374 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.RightShift, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 64:
#line 380 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 65:
#line 384 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Add, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 66:
#line 388 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Sub, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 67:
#line 395 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 68:
#line 399 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Mult, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 69:
#line 403 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Div, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 70:
#line 407 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.FloorDiv, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 71:
#line 411 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Modulo, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 72:
#line 418 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 73:
#line 422 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Minus, ((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 74:
#line 426 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 75:
#line 430 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.BitWiseInvert, ((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 76:
#line 437 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 77:
#line 441 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = new PyExpression(ExpressionType.Power, ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 78:
#line 447 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 79:
#line 451 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 80:
#line 455 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 81:
#line 459 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 82:
#line 463 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 83:
#line 469 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Subscription(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 84:
#line 473 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Subscription(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 85:
#line 479 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 86:
#line 483 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 87:
#line 487 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 88:
#line 493 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 89:
#line 497 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 90:
#line 520 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.AttributeRef(((IPyExpression)yyVals[-2+yyTop]), ((PyToken)yyVals[0+yyTop]));
		}
  break;
case 91:
#line 527 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 92:
#line 531 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 93:
#line 535 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 94:
#line 539 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 95:
#line 543 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 96:
#line 550 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParenthForm(null);
		}
  break;
case 97:
#line 554 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParenthForm(((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 98:
#line 558 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ParenthForm(((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 99:
#line 576 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.List(null);
		}
  break;
case 100:
#line 580 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.List(((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 101:
#line 584 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.List(((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 102:
#line 588 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.List(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 103:
#line 595 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 104:
#line 599 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 105:
#line 606 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListFor(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 106:
#line 610 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListFor(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 107:
#line 614 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListFor(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 108:
#line 618 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListFor(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 109:
#line 625 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListIf(((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 110:
#line 629 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.ListIf(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 111:
#line 636 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Generator(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 112:
#line 642 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorFor(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 113:
#line 646 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorFor(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 114:
#line 650 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorFor(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 115:
#line 654 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorFor(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 116:
#line 660 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 117:
#line 664 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 118:
#line 671 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorIf(((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 119:
#line 675 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.GeneratorIf(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 120:
#line 681 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 121:
#line 685 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.TargetList(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 122:
#line 692 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 123:
#line 699 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 124:
#line 711 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 125:
#line 715 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 126:
#line 719 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 127:
#line 726 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Dictionary(null, null);
		}
  break;
case 128:
#line 730 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 129:
#line 734 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 130:
#line 740 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Dictionary(((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 131:
#line 744 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Dictionary(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 132:
#line 751 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 133:
#line 757 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.KeyDatum(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 134:
#line 764 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.StringConversion(((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 135:
#line 771 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Slicing(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 136:
#line 777 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 137:
#line 781 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItemList(((IPyExpression)yyVals[-1+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 138:
#line 787 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[-1+yyTop]);
		}
  break;
case 139:
#line 794 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 140:
#line 798 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 141:
#line 805 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 142:
#line 809 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 143:
#line 816 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(PyExpressionFactory.Empty(), PyExpressionFactory.Empty());
		}
  break;
case 144:
#line 820 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(((IPyExpression)yyVals[-1+yyTop]), PyExpressionFactory.Empty());
		}
  break;
case 145:
#line 824 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(PyExpressionFactory.Empty(), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 146:
#line 828 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 147:
#line 834 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(((IPyExpression)yyVals[-1+yyTop]), PyExpressionFactory.Empty());
		}
  break;
case 148:
#line 838 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.SliceItem(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 149:
#line 844 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((PyToken)yyVals[0+yyTop]);
		}
  break;
case 150:
#line 851 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Call(((IPyExpression)yyVals[-2+yyTop]));
		}
  break;
case 151:
#line 855 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Call(((IPyExpression)yyVals[-3+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 152:
#line 859 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.Call(((IPyExpression)yyVals[-4+yyTop]), ((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[-1+yyTop]));
		}
  break;
case 153:
#line 866 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 154:
#line 870 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 155:
#line 874 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 156:
#line 878 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 157:
#line 882 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-5+yyTop]), ((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 158:
#line 886 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-5+yyTop]), ((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 159:
#line 890 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-6+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[-3+yyTop])), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 160:
#line 894 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-8+yyTop]), ((IPyExpression)yyVals[-6+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[-3+yyTop])), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 161:
#line 898 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[0+yyTop]), null);
		}
  break;
case 162:
#line 902 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 163:
#line 906 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-3+yyTop]), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 164:
#line 910 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-6+yyTop]), PyExpressionFactory.AsterArg(((IPyExpression)yyVals[-3+yyTop])), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 165:
#line 914 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(PyExpressionFactory.AsterArg(((IPyExpression)yyVals[0+yyTop])), null);
		}
  break;
case 166:
#line 918 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(PyExpressionFactory.AsterArg(((IPyExpression)yyVals[-3+yyTop])), PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])));
		}
  break;
case 167:
#line 922 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(PyExpressionFactory.AsterArg2(((IPyExpression)yyVals[0+yyTop])), null);
		}
  break;
case 168:
#line 928 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 169:
#line 932 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.CallArguments(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 170:
#line 938 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = ((IPyExpression)yyVals[0+yyTop]);
		}
  break;
case 171:
#line 942 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.KeywordArguments(((IPyExpression)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
case 172:
#line 948 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"
  {
			yyVal = PyExpressionFactory.KeywordItem(((PyToken)yyVals[-2+yyTop]), ((IPyExpression)yyVals[0+yyTop]));
		}
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: continue;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: continue;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

   static  short [] yyLhs  = {              -1,
    0,    2,    2,    1,    3,    3,    4,    4,    6,    6,
    5,    5,    8,    8,    7,    7,    9,    9,    9,    9,
    9,    9,    9,    9,   10,   10,   11,   12,   12,   13,
   13,   13,   14,   14,   15,   16,   16,   17,   17,   18,
   18,   19,   19,   20,   20,   20,   20,   20,   20,   20,
   20,   20,   20,   20,   21,   21,   22,   22,   23,   23,
   27,   27,   27,   26,   26,   26,   25,   25,   25,   25,
   25,   24,   24,   24,   24,   28,   28,   29,   29,   29,
   29,   29,   51,   51,   31,   31,   31,   30,   30,   32,
   33,   33,   33,   33,   33,   34,   34,   34,   35,   35,
   35,   35,   36,   36,   38,   38,   38,   38,   37,   37,
   39,   40,   40,   40,   40,   41,   41,   42,   42,   43,
   43,   44,   45,   45,   45,   45,   46,   46,   46,   47,
   47,   48,   49,   50,   52,   53,   53,   54,   55,   55,
   56,   56,   57,   57,   57,   57,   58,   58,   59,   60,
   60,   60,   61,   61,   61,   61,   61,   61,   61,   61,
   61,   61,   61,   61,   61,   61,   61,   62,   62,   63,
   63,   64,
  };
   static  short [] yyLen = {           2,
    1,    1,    2,    2,    1,    3,    1,    1,    1,    1,
    1,    5,    3,    4,    3,    4,    1,    1,    4,    4,
    7,    2,    5,    2,    1,    2,    2,    1,    3,    1,
    3,    3,    1,    2,    2,    1,    3,    1,    3,    1,
    2,    1,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    1,    2,    1,    3,    1,    3,    1,    3,
    1,    3,    3,    1,    3,    3,    1,    3,    3,    3,
    3,    1,    2,    2,    2,    1,    3,    1,    1,    1,
    1,    1,    4,    4,    1,    1,    1,    1,    1,    3,
    1,    1,    1,    1,    1,    2,    3,    3,    2,    3,
    3,    4,    1,    1,    4,    4,    5,    5,    2,    3,
    4,    4,    4,    5,    5,    1,    1,    2,    3,    1,
    2,    2,    1,    1,    1,    1,    2,    3,    3,    1,
    2,    2,    3,    3,    4,    1,    2,    2,    1,    1,
    1,    1,    1,    2,    2,    3,    2,    3,    1,    3,
    4,    5,    1,    3,    4,    4,    6,    6,    7,    9,
    1,    4,    4,    7,    2,    5,    2,    1,    3,    1,
    3,    3,
  };
   static  short [] yyDefRed = {            0,
   88,   85,    0,    0,    0,    0,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    2,    7,    8,    0,    0,
   38,   40,    0,    0,    0,   67,    0,    0,    0,   72,
    0,   86,   78,   79,   87,   91,   92,   93,   94,   95,
   80,   81,   82,   74,   73,   75,   96,    0,    0,    0,
   41,   30,    0,    0,    0,    0,    0,    0,    0,   25,
    0,   99,    0,    0,    0,  127,    0,    0,    0,  130,
    0,    3,    4,    0,    0,    0,    0,   44,   45,   46,
   47,   48,   49,   50,    0,    0,   53,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   98,   97,    0,    0,    0,   33,    0,    0,
   24,   13,    0,    0,   26,    0,  101,  100,    0,    0,
    0,  132,  128,  129,  131,  134,    0,    0,   39,    0,
   52,   54,   43,    0,    0,   68,   69,   70,   71,    0,
    0,    0,    0,    0,    0,  150,    0,  168,    0,    0,
    0,  170,   77,   90,    0,  149,    0,    0,    0,    0,
    0,  136,  139,    0,  142,  140,    0,    0,    0,    0,
    0,  120,    0,    0,  111,    0,   31,   35,   32,   34,
   14,    0,    0,   29,    0,    0,  102,  133,    0,    0,
    0,  167,  151,    0,    0,    0,  145,   84,   83,    0,
  138,  135,    0,  137,    0,    0,  122,    0,  121,    0,
    0,   20,    0,    0,   12,  172,    0,  152,    0,    0,
  169,    0,    0,    0,    0,  171,  146,  148,    0,    0,
   23,    0,    0,    0,    5,   10,    0,    0,    0,    0,
  156,    0,    0,  163,    0,  116,  114,  117,  115,    0,
    0,    0,    0,    0,  107,  104,  103,  108,  166,    0,
    0,    0,    0,    0,   21,   15,    0,    6,    0,    0,
    0,  158,    0,  119,   16,  110,  159,    0,  164,    0,
  160,
  };
  protected static  short [] yyDgoto  = {            13,
   14,   15,  234,   72,   17,  235,  236,   18,   57,   58,
   59,   60,   61,  109,  110,   19,   20,   21,   22,   88,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,  255,  256,  257,   38,  246,
  247,  248,  170,  171,  172,   39,   68,   69,   70,   40,
   41,   42,  160,  161,  162,  163,  164,  165,  166,   43,
  149,  150,  151,  152,
  };
  protected static  short [] yySindex = {          811,
    0,    0, -205, -205, -205,  -70,    0,  866,  -38,  -55,
  599,  811,    0,  811, -203,    0,    0,    0,  -66, -162,
    0,    0,  955, -156, -103,    0, -241, -194, -111,    0,
  -57,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  655, -184, -108,
    0,    0,  -62, -185,  -27,  811,  -88,  -67, -185,    0,
  -71,    0,  696,  -78,  -42,    0,  -31, -264,  739,    0,
 -168,    0,    0,  866,  866,  866, -205,    0,    0,    0,
    0,    0,    0,    0,  -24,  -14,    0, -205, -205, -205,
 -205, -205, -205, -205, -205, -205, -205, -205, -220, -205,
   13, -150,    0,    0,  -95,   25,    5,    0, -121,  -15,
    0,    0,  811, -233,    0,  811,    0,    0,  -95,   10,
  811,    0,    0,    0,    0,    0, -162, -258,    0, -156,
    0,    0,    0, -103, -111,    0,    0,    0,    0, -241,
 -241, -194, -194,    7,  811,    0,  811,    0, -247,   16,
   22,    0,    0,    0,  811,    0,  756,  -60,   45,  -59,
 -150,    0,    0,   61,    0,    0,    0, -135,    0,  -29,
  560,    0,    0,    0,    0,   84,    0,    0,    0,    0,
    0,   93,  114,    0,  -18,  887,    0,    0,  811,  811,
   87,    0,    0,  113, -110, -190,    0,    0,    0,  811,
    0,    0,   45,    0,  811,  866,    0,  866,    0,  122,
   94,    0,  825,  825,    0,    0,  117,    0,  811,  811,
    0,   98,    7,  811,  811,    0,    0,    0, -160, -160,
    0,  119,  -22,  -37,    0,    0,   96,  -37,  811,  100,
    0,  -77,  104,    0,  825,    0,    0,    0,    0,  135,
  825,  127,  825,  825,    0,    0,    0,    0,    0,  148,
  811,  811,  151,   47,    0,    0,  825,    0,   50,  811,
  133,    0,  811,    0,    0,    0,    0,  154,    0,  811,
    0,
  };
  protected static  short [] yyRindex = {            0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  423,    0,    0,    0,  586,  542,
    0,    0,  515,  452,  370,    0,   42,  165,  288,    0,
    1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -105,
    0,    0,    0,    0,    0,    0,    0,  138,  139,    0,
 -212,    0,    0,    0,   12,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  874,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  140,    0,    0,    0,
    0,    0,    0, -235,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  554,    0,    0,  493,
    0,    0,    0,  411,  329,    0,    0,    0,    0,   83,
  124,  206,  247,  929,    0,    0,    0,    0,    0, -231,
 -179,    0,    0,    0, -122,    0,    0,    0,   12,    0,
    0,    0,    0,   18,    0,    0,  600,    0,  639,    0,
    0,    0,  653,  669,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -176,    0,    0,    0,    0,    0,    0,    0,    0, -113,
    0,    0,    0,    0,   46,    0,    0,    0,    0,    0,
  141,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -166,    0,    0,    0,    0,    0,    0,  163,  164,
    0,    0,    0,  161,    0,    0, -167,  167,    0, -154,
    0,    0, -153,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  168,    0,    0,    0,    0,  169,    0,
 -148,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
  };
  protected static  short [] yyGindex = {            0,
    3,   -2,  220,  785,    0,  622,    0,    0,  224,    0,
    0,  404,  -40,    0,    0,  -75,  390,    4,  377,    0,
    0,  389,  378,    2,  149,  248,  379,    0, -102,    0,
    0,  -94,    0,    0,    0, -219,    0,  403,    0,  -48,
 -204,    0,  351,  355, -140,    0,    0,    0,  406,    0,
  -89,  -83,    0,    0,  334,    0,    0,    0,    0,    0,
    0,    0,  303, -181,
  };
  protected static  short [] yyTable = {           128,
   76,  106,  168,   49,   44,   45,   46,   64,   48,   71,
  169,   51,   63,  108,  226,  173,  168,  193,  258,   91,
   92,  174,   27,  122,  169,  249,   74,  182,   27,  173,
  209,  123,  189,  153,  183,  174,    1,  144,    3,    4,
  145,   64,    5,    6,  146,  209,  105,  147,    7,  276,
   27,    1,    2,    3,    4,   93,   94,    5,    6,  274,
  226,    8,  153,    7,   95,   96,    9,  223,  168,  180,
  224,   10,   52,   28,   11,   28,  169,  225,   54,  129,
  104,  173,   65,  168,   73,  161,   10,  174,  165,   11,
   12,  169,  136,  137,  138,  139,  173,    9,  154,  158,
  194,  153,  174,   73,  157,   12,    1,    2,    3,    4,
  155,  162,    5,    6,  161,   89,  157,  165,    7,   73,
    9,   76,    9,   66,   74,    9,    9,  154,   99,  245,
  229,    8,  230,  105,  101,  155,    9,  237,  237,  155,
  162,   10,  126,  177,   11,  157,    1,  144,    3,    4,
  219,  156,    5,    6,   97,   98,  102,  220,    7,    2,
   12,    1,  167,  143,   61,  143,  178,   90,    6,  237,
  143,    8,  144,    7,  144,  237,    9,  237,  237,  144,
  223,   10,    2,  261,   11,  105,    1,    2,    3,    4,
  262,  237,    5,    6,   47,  107,   10,  113,    7,   11,
   12,    1,    2,    3,    4,   62,   99,    5,    6,   73,
  100,    8,  101,    7,  118,   12,    9,  116,   74,   52,
  114,   10,   53,   75,   11,   54,    8,   73,  201,   55,
  111,    9,  199,  202,  102,   52,   10,   62,   53,   11,
   12,   54,   52,  140,  141,   55,   63,   56,   54,  179,
  253,  119,  254,  206,  121,   12,  119,  131,  207,   76,
   76,   76,   76,  251,  213,   76,   76,   76,  132,  207,
  154,   76,   76,   76,   76,   76,   76,   76,   76,   76,
   76,   76,   76,   76,   76,   76,   76,   59,   76,  175,
   76,   76,  176,   76,   76,  190,   76,   76,   76,    2,
   64,   64,  187,  195,    2,  141,   64,   64,   64,  196,
  141,   76,   64,   64,   64,   64,   64,   64,   64,   64,
   64,   64,   64,   64,   64,   64,   64,   64,   60,   64,
  200,   64,   64,  147,   64,   64,  245,   64,  147,  254,
  105,   65,   65,  119,  142,  143,  205,   65,   65,   65,
  211,  210,   64,   65,   65,   65,   65,   65,   65,   65,
   65,   65,   65,   65,   65,   65,   65,   65,   65,   57,
   65,  212,   65,   65,  217,   65,   65,  218,   65,  231,
   74,  232,   66,   66,  239,  242,  250,  260,   66,   66,
   66,  263,  265,   65,   66,   66,   66,   66,   66,   66,
   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
   58,   66,  267,   66,   66,  270,   66,   66,  273,   66,
  278,  280,    1,   17,   18,   22,   19,  112,  113,   61,
   61,   61,  118,  238,   66,   61,   61,   61,   61,   61,
   61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
   61,   55,   61,  105,   61,   61,  252,   61,   61,  106,
   61,  109,  115,  127,  133,  130,  134,  120,  135,  185,
   62,   62,   62,  186,  125,   61,   62,   62,   62,   62,
   62,   62,   62,   62,   62,   62,   62,   62,   62,   62,
   62,   62,   56,   62,  204,   62,   62,  222,   62,   62,
    0,   62,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   63,   63,   63,   42,    0,   62,   63,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,    0,   63,    0,   63,   63,    0,   63,
   63,   36,   63,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   59,   37,    0,    0,    0,   63,   59,   59,
   59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
   59,   59,   59,   59,    0,   59,    0,   59,   59,    0,
   59,   59,    0,   59,    0,   11,    0,    0,    0,    0,
    0,    0,    0,   60,    0,    0,    0,    0,   59,   60,
   60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
   60,   60,   60,   60,   60,    0,   60,    0,   60,   60,
    0,   60,   60,    0,   60,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   57,    0,    0,    0,    0,   60,
    0,   57,   57,   57,   57,   57,   57,   57,   57,   57,
   57,   57,   57,   57,   57,   57,    0,   57,    0,   57,
   57,    0,   57,   57,    0,   57,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,    0,    0,    0,
   57,    0,   58,   58,   58,   58,   58,   58,   58,   58,
   58,   58,   58,   58,   58,   58,   58,    0,   58,    0,
   58,   58,    0,   58,   58,    0,   58,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,    0,    0,    0,
    0,   58,    0,    0,   55,   55,   55,   55,   55,   55,
   55,   55,   55,   55,   55,   55,   55,   55,    0,   55,
    0,   55,   55,    0,   55,   55,    0,   55,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   56,    0,    0,
    0,    0,   55,    0,    0,   56,   56,   56,   56,   56,
   56,   56,   56,   56,   56,   56,   56,   56,   56,   42,
   56,    0,   56,   56,   16,   56,   56,    0,   56,    0,
   50,    0,    0,    0,   65,   67,   16,    0,   42,   42,
   42,    0,   42,   56,   42,   42,   36,   42,   42,    0,
   42,    0,    0,    0,    0,    0,    1,  167,   37,    0,
    0,    0,    0,    6,    0,   42,   36,   36,    7,   36,
    0,   36,   36,    0,   36,   36,    0,   36,   37,   37,
  112,   37,  208,   37,   37,    0,   37,   37,    0,   37,
   11,   10,   36,   67,   11,    1,    2,    3,    4,    0,
    0,    5,    6,   85,   37,    0,  264,    7,    0,   85,
   12,   11,  266,   11,  268,  269,    0,    0,   11,   11,
    8,   11,  123,  148,    0,    9,  159,  123,  275,    0,
   10,   85,    0,   11,   66,    0,   11,  181,    0,    0,
  184,    0,   79,    0,    0,  188,    0,    0,   79,   12,
    0,    1,    2,    3,    4,    0,   80,    5,    6,  103,
    0,  124,   80,    7,    0,    0,  124,    0,    0,  191,
   79,  192,   81,    0,    0,  125,    8,    0,   81,  197,
  125,    9,    0,    0,   80,  203,   10,    0,    0,   11,
    0,  126,    1,    2,    3,    4,  126,    0,    5,    6,
   81,    0,    0,    0,    7,   12,    0,    0,    0,    0,
    0,    0,    0,  215,  216,    0,    0,    8,    0,  221,
    0,    0,    9,    0,  227,    0,    0,   10,  117,  228,
   11,    0,    0,    0,    0,    1,    2,    3,    4,    0,
    0,    5,    6,  240,  241,    0,   12,    7,  243,  244,
    0,    0,    1,    2,    3,    4,    0,    0,    5,    6,
    8,    0,    0,  259,    7,    9,    0,    0,    0,    0,
   10,    0,    0,   11,  124,    0,    0,    8,    0,    0,
    0,    0,    9,    0,    0,  271,  272,   10,  198,   12,
   11,    0,    0,    0,  277,    0,    0,  279,    0,    0,
    0,    0,    0,    0,  281,    0,   12,    1,    2,    3,
    4,    0,    0,    5,    6,    0,    0,    0,    0,    7,
    0,    1,    2,    3,    4,    0,    0,    5,    6,    0,
    0,    0,    8,    7,    0,    0,    0,    9,    0,    0,
    0,    0,   10,    0,    0,   11,    8,    0,    0,    0,
    0,  233,    0,    0,    0,    0,   10,    0,    0,   11,
    0,   12,    1,    2,    3,    4,    0,    0,    5,    6,
   51,   51,   51,   51,    7,   12,   51,   51,    0,    0,
    0,    0,   51,    1,  167,    0,    0,    8,    0,    0,
    6,    0,    0,    0,    0,    7,    0,   10,    0,    0,
   11,    0,    0,    0,    0,   51,    0,    0,   51,  214,
    0,    0,    0,    0,    0,    0,   12,    0,   10,    0,
    0,   11,    0,    0,   51,    0,    0,   85,   85,   85,
   85,    0,   85,   85,   85,   85,   85,   12,   85,   85,
   85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
   85,   85,   85,   85,    0,    0,   85,    0,   85,    0,
   85,    0,   85,    0,    0,   85,   85,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,
  };
  protected static  short [] yyCheck = {            75,
    0,   50,  105,    6,    3,    4,    5,   10,    6,   12,
  105,    8,   10,   54,  196,  105,  119,  265,  238,  261,
  262,  105,  258,  288,  119,  230,  285,  261,  264,  119,
  171,  296,  291,  265,  268,  119,  257,  258,  259,  260,
  261,    0,  263,  264,  265,  186,  294,  268,  269,  269,
  286,  257,  258,  259,  260,  297,  298,  263,  264,  264,
  242,  282,  294,  269,  259,  260,  287,  258,  171,  110,
  261,  292,  258,  286,  295,  288,  171,  268,  264,   76,
  265,  171,    0,  186,  288,  265,  292,  171,  265,  295,
  311,  186,   91,   92,   93,   94,  186,  265,  265,  102,
  149,  100,  186,  288,  102,  311,  257,  258,  259,  260,
  265,  265,  263,  264,  294,  272,  265,  294,  269,  288,
  288,  284,  290,    0,  285,  293,  294,  294,  264,  290,
  206,  282,  208,  294,  270,  286,  287,  213,  214,  294,
  294,  292,  311,  265,  295,  294,  257,  258,  259,  260,
  261,  302,  263,  264,  266,  267,  292,  268,  269,  265,
  311,  257,  258,  286,    0,  288,  288,  271,  264,  245,
  293,  282,  286,  269,  288,  251,  287,  253,  254,  293,
  258,  292,  288,  261,  295,  294,  257,  258,  259,  260,
  268,  267,  263,  264,  265,  258,  292,  286,  269,  295,
  311,  257,  258,  259,  260,    0,  264,  263,  264,  288,
  268,  282,  270,  269,  293,  311,  287,  289,  285,  258,
  288,  292,  261,  290,  295,  264,  282,  288,  288,  268,
  258,  287,  293,  293,  292,  258,  292,  293,  261,  295,
  311,  264,  258,   95,   96,  268,    0,  286,  264,  265,
  288,  294,  290,  283,  286,  311,  294,  282,  288,  259,
  260,  261,  262,  286,  283,  265,  266,  267,  283,  288,
  258,  271,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,    0,  288,  265,
  290,  291,  288,  293,  294,  289,  296,  297,  298,  288,
  259,  260,  293,  288,  293,  288,  265,  266,  267,  288,
  293,  311,  271,  272,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,    0,  288,
  286,  290,  291,  288,  293,  294,  290,  296,  293,  290,
  294,  259,  260,  294,   97,   98,  286,  265,  266,  267,
  258,  268,  311,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,    0,
  288,  258,  290,  291,  288,  293,  294,  265,  296,  258,
  285,  288,  259,  260,  268,  288,  268,  288,  265,  266,
  267,  288,  258,  311,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
    0,  288,  286,  290,  291,  268,  293,  294,  268,  296,
  288,  268,    0,  286,  286,  286,  286,  265,  265,  265,
  266,  267,  265,  214,  311,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,    0,  288,  293,  290,  291,  233,  293,  294,  293,
  296,  293,   59,   74,   88,   77,   89,   65,   90,  119,
  265,  266,  267,  119,   69,  311,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,    0,  288,  161,  290,  291,  195,  293,  294,
   -1,  296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  265,  266,  267,    0,   -1,  311,  271,  272,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,   -1,  288,   -1,  290,  291,   -1,  293,
  294,    0,  296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  265,    0,   -1,   -1,   -1,  311,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,   -1,  288,   -1,  290,  291,   -1,
  293,  294,   -1,  296,   -1,    0,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  265,   -1,   -1,   -1,   -1,  311,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,   -1,  288,   -1,  290,  291,
   -1,  293,  294,   -1,  296,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  265,   -1,   -1,   -1,   -1,  311,
   -1,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,   -1,  288,   -1,  290,
  291,   -1,  293,  294,   -1,  296,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  265,   -1,   -1,   -1,   -1,
  311,   -1,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,   -1,  288,   -1,
  290,  291,   -1,  293,  294,   -1,  296,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  265,   -1,   -1,   -1,
   -1,  311,   -1,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,   -1,  288,
   -1,  290,  291,   -1,  293,  294,   -1,  296,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  265,   -1,   -1,
   -1,   -1,  311,   -1,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  265,
  288,   -1,  290,  291,    0,  293,  294,   -1,  296,   -1,
    6,   -1,   -1,   -1,   10,   11,   12,   -1,  284,  285,
  286,   -1,  288,  311,  290,  291,  265,  293,  294,   -1,
  296,   -1,   -1,   -1,   -1,   -1,  257,  258,  265,   -1,
   -1,   -1,   -1,  264,   -1,  311,  285,  286,  269,  288,
   -1,  290,  291,   -1,  293,  294,   -1,  296,  285,  286,
   56,  288,  283,  290,  291,   -1,  293,  294,   -1,  296,
  265,  292,  311,   69,  295,  257,  258,  259,  260,   -1,
   -1,  263,  264,  264,  311,   -1,  245,  269,   -1,  270,
  311,  286,  251,  288,  253,  254,   -1,   -1,  293,  294,
  282,  296,  283,   99,   -1,  287,  102,  288,  267,   -1,
  292,  292,   -1,  295,  296,   -1,  311,  113,   -1,   -1,
  116,   -1,  264,   -1,   -1,  121,   -1,   -1,  270,  311,
   -1,  257,  258,  259,  260,   -1,  264,  263,  264,  265,
   -1,  283,  270,  269,   -1,   -1,  288,   -1,   -1,  145,
  292,  147,  264,   -1,   -1,  283,  282,   -1,  270,  155,
  288,  287,   -1,   -1,  292,  161,  292,   -1,   -1,  295,
   -1,  283,  257,  258,  259,  260,  288,   -1,  263,  264,
  292,   -1,   -1,   -1,  269,  311,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  189,  190,   -1,   -1,  282,   -1,  195,
   -1,   -1,  287,   -1,  200,   -1,   -1,  292,  293,  205,
  295,   -1,   -1,   -1,   -1,  257,  258,  259,  260,   -1,
   -1,  263,  264,  219,  220,   -1,  311,  269,  224,  225,
   -1,   -1,  257,  258,  259,  260,   -1,   -1,  263,  264,
  282,   -1,   -1,  239,  269,  287,   -1,   -1,   -1,   -1,
  292,   -1,   -1,  295,  296,   -1,   -1,  282,   -1,   -1,
   -1,   -1,  287,   -1,   -1,  261,  262,  292,  293,  311,
  295,   -1,   -1,   -1,  270,   -1,   -1,  273,   -1,   -1,
   -1,   -1,   -1,   -1,  280,   -1,  311,  257,  258,  259,
  260,   -1,   -1,  263,  264,   -1,   -1,   -1,   -1,  269,
   -1,  257,  258,  259,  260,   -1,   -1,  263,  264,   -1,
   -1,   -1,  282,  269,   -1,   -1,   -1,  287,   -1,   -1,
   -1,   -1,  292,   -1,   -1,  295,  282,   -1,   -1,   -1,
   -1,  287,   -1,   -1,   -1,   -1,  292,   -1,   -1,  295,
   -1,  311,  257,  258,  259,  260,   -1,   -1,  263,  264,
  257,  258,  259,  260,  269,  311,  263,  264,   -1,   -1,
   -1,   -1,  269,  257,  258,   -1,   -1,  282,   -1,   -1,
  264,   -1,   -1,   -1,   -1,  269,   -1,  292,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  292,   -1,   -1,  295,  283,
   -1,   -1,   -1,   -1,   -1,   -1,  311,   -1,  292,   -1,
   -1,  295,   -1,   -1,  311,   -1,   -1,  259,  260,  261,
  262,   -1,  264,  265,  266,  267,  268,  311,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,   -1,   -1,  288,   -1,  290,   -1,
  292,   -1,  294,   -1,   -1,  297,  298,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,
  };

#line 953 "F:\work\excaliper\MiddleWare\PythonEditor\Editor\Parser\IronPythonParser\InternalParser.jay"

    } // class ̕
// namespace p̕ʂ͗vȂ
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int Number = 257;
  public const int Identifier = 258;
  public const int plus = 259;
  public const int dash = 260;
  public const int asterisk = 261;
  public const int slash = 262;
  public const int tilde = 263;
  public const int parenOpen = 264;
  public const int parenClose = 265;
  public const int leftShift = 266;
  public const int rightShift = 267;
  public const int asterisk2 = 268;
  public const int stringliteral = 269;
  public const int dot = 270;
  public const int ampersand = 271;
  public const int caret = 272;
  public const int verticalBar = 273;
  public const int lessThan = 274;
  public const int graterThan = 275;
  public const int equal2 = 276;
  public const int graterEqual = 277;
  public const int lessEqual = 278;
  public const int notEqual2 = 279;
  public const int notEqual = 280;
  public const int reserved_is = 281;
  public const int reserved_not = 282;
  public const int reserved_in = 283;
  public const int reserved_and = 284;
  public const int reserved_or = 285;
  public const int colon = 286;
  public const int reserved_lambda = 287;
  public const int comma = 288;
  public const int equal = 289;
  public const int reserved_if = 290;
  public const int reserved_else = 291;
  public const int bracketOpen = 292;
  public const int bracketClose = 293;
  public const int reserved_for = 294;
  public const int braceOpen = 295;
  public const int braceClose = 296;
  public const int slash2 = 297;
  public const int percent = 298;
  public const int powerEqual = 299;
  public const int rightShiftEqual = 300;
  public const int leftShiftEqual = 301;
  public const int dot3 = 302;
  public const int plusEqual = 303;
  public const int minusEqual = 304;
  public const int asteriskEqua = 305;
  public const int slashEqual = 306;
  public const int percentEqual = 307;
  public const int ampersandEqual = 308;
  public const int caretEqual = 309;
  public const int verticalBarEqual = 310;
  public const int backApostrophe = 311;
  public const int atSign = 312;
  public const int reserved_as = 313;
  public const int reserved_assert = 314;
  public const int reserved_break = 315;
  public const int reserved_class = 316;
  public const int reserved_continue = 317;
  public const int reserved_def = 318;
  public const int reserved_del = 319;
  public const int reserved_elif = 320;
  public const int reserved_except = 321;
  public const int reserved_exec = 322;
  public const int reserved_finally = 323;
  public const int reserved_from = 324;
  public const int reserved_global = 325;
  public const int reserved_import = 326;
  public const int reserved_pass = 327;
  public const int reserved_print = 328;
  public const int reserved_raise = 329;
  public const int reserved_return = 330;
  public const int reserved_try = 331;
  public const int reserved_while = 332;
  public const int reserved_with = 333;
  public const int reserved_yield = 334;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
