﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor.Parser.IronPythonParser
{
    class PyCompositionToken : IPyExpression, IPyToken
    {
        readonly IPyToken _token1;
        readonly IPyToken _token2;
        readonly TokenType _type;

        internal PyCompositionToken(IPyExpression token1, IPyExpression token2, TokenType type)
        {
            _token1 = token1 as IPyToken;
            _token2 = token2 as IPyToken;
            _type = type;
        }

        #region IExpression メンバ

        public string ToText()
        {
            return Text;
        }
        public PyTypeInfo GetTypeInfo(INameResolve resolver)
        {
            throw new NotSupportedException();
        }

        public string ToOriginalText()
        {
            return _token1.Text + " " + _token2.Text;
        }

        #endregion

        #region IPyToken メンバ

        public string Text
        {
            get { return _token1.Text + " " + _token2.Text; }
        }

        public TokenType Type
        {
            get { return _type; }
        }

        #endregion


    }
}
