﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor.Parser.IronPythonParser
{
    class PyTokenCollection : List<PyToken>
    {
        internal PyToken GetTokenAt(int index)
        {
            int indexInToken;
            return GetTokenAt(index, out indexInToken);
        }

        internal PyToken GetTokenAt(int index, out int indexInToken)
        {
            int length = 0;
            foreach (var item in this)
            {
                if (length <= index && index < length + item.Text.Length)
                {
                    indexInToken = index - length;
                    return item;
                }
                length += item.Text.Length;
            }
            indexInToken = 0;
            return null;
        }

        internal PyTokenCollection CreateWithoutWhiteSpace()
        {
            PyTokenCollection result = new PyTokenCollection();
            foreach (var item in this)
            {
                if (item.Type != TokenType.whiteSpece)
                {
                    result.Add(item);
                }
            }
            return result;
        }
        internal string GetOriginalText()
        {
            StringBuilder str = new StringBuilder();
            foreach (var item in this)
            {
                str.Append(item.ToOriginalText());
            }
            return str.ToString();
        }
        internal int GetLength()
        {
            int length = 0;
            foreach (var item in this)
            {
                length += item.Text.Length;
            }
            return length;
        }

        internal PyTokenCollection GetSubTokens(string text)
        {
            PyTokenCollection result = new PyTokenCollection();
            string str = "";
            for (int i = 0; i < this.Count; i++)
            {
                str = str + this[i].ToOriginalText();
                if (text.StartsWith(str) == true)
                {
                    result.Add(this[i]);
                }
                else
                {
                    break;
                }
            }
            return result;
        }
    }
}
