﻿using System;
using System.Collections.Generic;
using System.Text;
using Editor.Parser.IronPythonParser;

namespace Editor.Parser
{
    class ParserCache
    {
        Dictionary<string, IPyExpression> _cache = new Dictionary<string, IPyExpression>();
        PyParser parser = new PyParser();
        internal IPyExpression Parse(string text)
        {
            IPyExpression exp;
            if (_cache.TryGetValue(text, out exp) == false)
            {
                try
                {
                    exp = parser.Parse(text);
                    _cache[text] = exp;
                }
                catch(ParseErrorException)
                {
                    return new PyExpression(ExpressionType.Empty);
                }
            }
            return exp;
        }

        internal void Clear()
        {
            _cache = new Dictionary<string, IPyExpression>();
        }
    }
}
