﻿using System;
using System.Collections.Generic;
using System.Text;
using Editor.Parser.IronPythonParser;

namespace Editor.Parser
{
    class Primary
    {
        readonly PyTokenCollection _tokens;
        readonly PrimaryType _type;
        string _name = "";
        internal Primary(PyTokenCollection tokens, PrimaryType type)
        {
            _tokens = tokens;
            _type = type;
        }

        internal Primary(PyToken token, PrimaryType type)
            :this(new PyTokenCollection(){token}, type)
        {
        }

        internal int TokenCount { get { return _tokens.Count; } }
        internal String ToText()
        {
            StringBuilder str = new StringBuilder();
            foreach (var item in _tokens)
            {
                str.Append(item.Text);
                str.Append(" ");
            }
            return str.ToString();
        }
        internal string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        internal PrimaryType Type
        {
            get { return _type; }
        }

    }

    enum PrimaryType
    {
        identifier,
        Method,
        Subscription,
        ParenExpression,
        Text,
        Terminal,
        Dictionary
    }
}
