﻿using System.Runtime.InteropServices;
using System.Drawing;

namespace Editor
{
    static class Win32
    {
        [DllImport("user32.dll", EntryPoint = "GetCaretPos", CallingConvention = CallingConvention.Winapi)]
        private static extern uint GetCaretPos(ref PointAPI caretPoint);

        public struct PointAPI
        {
            public uint x, y;
            public PointAPI(uint p1, uint p2)
            {
                x = p1;
                y = p2;
            }
        }

        internal static Point GetCaretPosition()
        {
            PointAPI pos = new PointAPI();
            GetCaretPos(ref pos);
            return new Point((int)pos.x, (int)pos.y);
        }
    }
}
