﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using NUnit.Framework.SyntaxHelpers;
using Editor.Parser;
using Editor;

namespace EditorTest.Parser
{
    [TestFixture]
    public class PythonParserTest
    {
        PythonParser parser;

        [SetUp]
        public void SetUp()
        {
            parser = new PythonParser();
        }
        [TearDown]
        public void TearDown()
        {
        }

        //[Test]
        public void 複雑な入力でどの場所にカーソルがあっても落ちないこと()
        {
            string text = "Method(Object, x[0:1:2]>=0 AND y[x(),10]>0 ,r\"\" ,\"Text()\", `Method()+1`, (x for x in range(100) if x%2==0), [AA, BB(lambda x,y : x + y)], (AA, BB.CC()), Method(), Cls.Method(CC, DD.Property)).Property.Member";
            for (int i = 0; i <= text.Length; i++)
            {
                ParseResult result = (ParseResult)parser.Parse(text, i);
            }
        }
        [Test]
        public void 変数のインテリセンス取得()
        {
            string text = "AA.";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("AA"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void 変数のメンバ途中のインテリセンス取得()
        {
            string text = "AA.BB";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("AA"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void 変数のみの場合のインテリセンス取得()
        {
            string text = "AA";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo(""));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void カンマの直後でインテリセンスを出さない()
        {
            string text = "Method(AA.BB,";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo(""));
            Assert.That(result.IsShowIntelisence(), Is.False);
        }
        [Test]
        public void 文字列の後のドット()
        {
            string text = "\"TEXT\".";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("''"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void 文字列の直後()
        {
            string text = "\"TEXT\"";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            //Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo(""));
            Assert.That(result.IsShowIntelisence(), Is.False);
        }
        [Test]
        public void 整数の後のドットは小数点に見えるため出ない()
        {
            string text = "100.";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            //Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("100"));
            Assert.That(result.IsShowIntelisence(), Is.False);
        }
        [Test]
        public void 八進数の後のドットは出る()
        {
            string text = "0123.";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("0123"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void 十六進数の後のドットは出る()
        {
            string text = "0x01.";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("0x01"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
        [Test]
        public void 浮動小数点の後のドットは出る()
        {
            string text = "1.0.";
            ParseResult result = (ParseResult)parser.Parse(text, text.Length);
            Assert.That(result.IntelisenceExpression.ToOriginalText(), Is.EqualTo("1.0"));
            Assert.That(result.IsShowIntelisence(), Is.True);
        }
    }

}
