﻿using System;
using IronPython.Hosting;
using NUnit.Framework;
using NUnit.Framework.SyntaxHelpers;

namespace EditorTest
{
    [TestFixture]
    public class  PythonTest
    {
        private IronPython.Hosting.PythonEngine _engine;
        [SetUp]
        public void SetUp()
        {
            _engine = new PythonEngine();
        }

        [TearDown]
        public void TearDown()
        {
            
        }

        [Test]
        public void Test()
        {
            _engine.Execute("import System");
            object obj = _engine.Evaluate("System.IO.Path");
            Type pyType = obj.GetType();
            Assert.That(pyType, Is.EqualTo(typeof(IronPython.Runtime.Types.ReflectedType)));
            var type = obj as IronPython.Runtime.Types.DynamicType;
            Type dotNetType = type.type;
            Assert.That(dotNetType, Is.EqualTo(typeof(System.IO.Path)));

            obj = _engine.Evaluate("abs");
            pyType = obj.GetType();
            Assert.That(pyType, Is.EqualTo(typeof(IronPython.Runtime.Calls.BuiltinFunction)));
            var type2 = obj as IronPython.Runtime.Calls.FastCallable;

            obj = _engine.Evaluate("System");
            pyType = obj.GetType();
            Assert.That(pyType, Is.EqualTo(typeof(IronPython.Runtime.PythonModule)));
            //Type str = obj.GetType();
        }
    }
    //[TestFixture]
    //public class PySentenceTest
    //{
    //    PySentence _sentence;

    //    [Test]
    //    public void Test()
    //    {
    //        _sentence = PySentence.Parse("AA.BB CCC.DDD.EEE");
    //        Assert.That(_sentence.Count, Is.EqualTo(3));
    //        Assert.That(_sentence[0].Text, Is.EqualTo("AA.BB"));
    //        Assert.That(_sentence[1].Text, Is.EqualTo(" "));
    //        Assert.That(_sentence[2].Text, Is.EqualTo("CCC.DDD.EEE"));

    //        Assert.That(((PyClass)_sentence[0])[0].Text, Is.EqualTo("AA"));
    //        Assert.That(((PyClass)_sentence[0])[1].Text, Is.EqualTo("."));
    //        Assert.That(((PyClass)_sentence[0])[2].Text, Is.EqualTo("BB"));

    //        Assert.That(((PyClass)_sentence[2])[0].Text, Is.EqualTo("CCC"));
    //        Assert.That(((PyClass)_sentence[2])[1].Text, Is.EqualTo("."));
    //        Assert.That(((PyClass)_sentence[2])[2].Text, Is.EqualTo("DDD"));
    //        Assert.That(((PyClass)_sentence[2])[3].Text, Is.EqualTo("."));
    //        Assert.That(((PyClass)_sentence[2])[4].Text, Is.EqualTo("EEE"));

    //    }

    //    [Test]
    //    public void Test2()
    //    {
    //        _sentence = PySentence.Parse("AA.BB CCC.DDD.EEE");

    //        PyClass cls = _sentence.GetClass(0);
    //        Assert.That(cls, Is.EqualTo(_sentence[0]));

    //        cls = _sentence.GetClass(1);
    //        Assert.That(cls, Is.EqualTo(_sentence[0]));

    //        cls = _sentence.GetClass(5);
    //        Assert.That(cls, Is.EqualTo(_sentence[0]));

    //        cls = _sentence.GetClass(6);
    //        Assert.That(cls, Is.EqualTo(_sentence[2]));
    //    }

    //    [Test]
    //    public void Test3()
    //    {
    //        _sentence = PySentence.Parse("AA.BB CCC.DDD.EEE");
    //        PyClass cls = _sentence.GetClassBeforeAt(4);
    //        Assert.That(cls.Text, Is.EqualTo("AA"));

    //        cls = _sentence.GetClassBeforeAt(15);
    //        Assert.That(cls.Text, Is.EqualTo("CCC.DDD"));
    //    }

    //    [Test]
    //    public void Test4()
    //    {
    //        _sentence = PySentence.Parse("AA.BB CCC.DDD.EEE");
    //        PyWord token;

    //        token = _sentence.GetToken(0);
    //        Assert.That(token.Text, Is.EqualTo("AA"));

    //        token = _sentence.GetToken(1);
    //        Assert.That(token.Text, Is.EqualTo("AA"));

    //        token = _sentence.GetToken(2);
    //        Assert.That(token.Text, Is.EqualTo("AA"));

    //        token = _sentence.GetToken(3);
    //        Assert.That(token.Text, Is.EqualTo("BB"));

    //        token = _sentence.GetToken(15);
    //        Assert.That(token.Text, Is.EqualTo("EEE"));

    //    }

    //    [Test]
    //    public void Test5()
    //    {
    //        _sentence = PySentence.Parse("AA.BB CCC.DDD.EEE");
    //        PyWord token;

    //        token = _sentence.GetTokenBeforeAt(0);
    //        Assert.That(token.Text, Is.EqualTo(""));

    //        token = _sentence.GetTokenBeforeAt(1);
    //        Assert.That(token.Text, Is.EqualTo("A"));

    //        token = _sentence.GetTokenBeforeAt(2);
    //        Assert.That(token.Text, Is.EqualTo("AA"));

    //        token = _sentence.GetTokenBeforeAt(3);
    //        Assert.That(token.Text, Is.EqualTo(""));

    //        token = _sentence.GetTokenBeforeAt(4);
    //        Assert.That(token.Text, Is.EqualTo("B"));
            
    //        token = _sentence.GetTokenBeforeAt(5);
    //        Assert.That(token.Text, Is.EqualTo("BB"));


    //        token = _sentence.GetTokenBeforeAt(15);
    //        Assert.That(token.Text, Is.EqualTo("E"));

    //    }

    //}
}
