﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Editor;

namespace IronPythonIntelisence
{
    public partial class CustomTextBox : TextBox, IPythonTextBox
    {
        public CustomTextBox()
        {
            InitializeComponent();
            LocationChanged += new EventHandler(CustomTextBox_LocationChanged);
        }

        void CustomTextBox_LocationChanged(object sender, EventArgs e)
        {
            OnLocationChangedAndWindowLocationChanged();
        }

        protected void OnLocationChangedAndWindowLocationChanged()
        {
            if (LocationChangedAndWindowLocationChanged != null)
            {
                LocationChangedAndWindowLocationChanged(this, new EventArgs());
            }
        }

        #region IPythonTextBox メンバ

        public void GetText(out string text, out int currentIndex)
        {
            text = this.Text;
            currentIndex = this.SelectionStart;
        }

        public void SetText(string text, int cursorIndex)
        {
            this.Text = text;
            this.Select(cursorIndex, 0);
        }

        public event EventHandler LocationChangedAndWindowLocationChanged;

        #endregion


    }
}
