﻿using System;
using System.Collections.Generic;
using System.Text;
using IrrlichtNetSwig;

namespace _2DGraphics
{
    class Program
    {
        static void Main(string[] args)
        {
            // let user select driver type

            E_DRIVER_TYPE driverType;

            Console.WriteLine(
                @"Please select the driver you want for this example:
 (a) Direct3D 9.0c
 (b) Direct3D 8.1
 (c) OpenGL 1.5
 (d) Software Renderer
 (e) Burning's Software Renderer
 (f) NullDevice\n (otherKey) exit");

            ConsoleKeyInfo consoleKeyInfo = Console.ReadKey(true);

            switch (consoleKeyInfo.KeyChar)
            {
                case 'a': driverType = E_DRIVER_TYPE.EDT_DIRECT3D9; break;
                case 'b': driverType = E_DRIVER_TYPE.EDT_DIRECT3D8; break;
                case 'c': driverType = E_DRIVER_TYPE.EDT_OPENGL; break;
                case 'd': driverType = E_DRIVER_TYPE.EDT_SOFTWARE; break;
                case 'e': driverType = E_DRIVER_TYPE.EDT_BURNINGSVIDEO; break;
                case 'f': driverType = E_DRIVER_TYPE.EDT_NULL; break;
                default: return;
            }

            // create device

            IrrlichtDevice device = IrrlichtNet.createDevice(driverType,
                new dimension2di(512, 384));

            if (device == null)
                return; // could not create selected driver.

            device.setWindowCaption("Irrlicht Engine - 2D Graphics Demo");

            IVideoDriver driver = device.getVideoDriver();

            /*
            All 2d graphics in this example are put together into one texture,
            2ddemo.bmp. Because we want to draw colorkey based sprites, we need to
            load this texture and tell the engine, which part of it should be
            transparent based on a colorkey.

            In this example, we don't tell it the color directly, we just say "Hey
            Irrlicht Engine, you'll find the color I want at position (0,0) on the
            texture.". Instead, it would be also possible to call
            driver.makeColorKeyTexture(images, video::SColor(0,0,0,0)), to make
            e.g. all black pixels transparent. Please note that
            makeColorKeyTexture just creates an alpha channel based on the color.
            */
            ITexture images = driver.getTexture("../../media/2ddemo.bmp");
            driver.makeColorKeyTexture(images, new position2di(0, 0));

            /*
            To be able to draw some text with two different fonts, we first load
            them. Ok, we load just one. As the first font we just use the default
            font which is built into the engine. Also, we define two rectangles
            which specify the position of the images of the red imps (little flying
            creatures) in the texture.
            */
            IGUIFont font = device.getGUIEnvironment().getBuiltInFont();
            IGUIFont font2 =
                device.getGUIEnvironment().getFont("../../media/fonthaettenschweiler.bmp");

            recti imp1 = new recti(349, 15, 385, 78);
            recti imp2 = new recti(387, 15, 423, 78);

            /*
            Everything is prepared, now we can draw everything in the draw loop,
            between the begin scene and end scene calls. In this example, we are
            just doing 2d graphics, but it would be no problem to mix them with 3d
            graphics. Just try it out, and draw some 3d vertices or set up a scene
            with the scene manager and draw it.
            */
            while (device.run())
            {
                if (device.isWindowActive())
                {
                    uint time = device.getTimer().getTime();

                    driver.beginScene(true, true, new SColor(255, 120, 102, 136));

                    /*
                    First, we draw 3 sprites, using the alpha channel we
                    created with makeColorKeyTexture. The last parameter
                    specifies that the drawing method should use this alpha
                    channel. The last-but-one parameter specifies a
                    color, with which the sprite should be colored.
                    (255,255,255,255) is full white, so the sprite will
                    look like the original. The third sprite is drawn
                    with the red channel modulated based on the time.
                    */

                    // draw fire & dragons background world
                    driver.draw2DImage(images, new position2di(50, 50),
                        new recti(0, 0, 342, 224), null,
                        new SColor(255, 255, 255, 255), true);

                    // draw flying imp
                    driver.draw2DImage(images, new position2di(164, 125),
                        (time / 500 % 2) == 1 ? imp1 : imp2, null,
                        new SColor(255, 255, 255, 255), true);

                    // draw second flying imp with colorcylce
                    driver.draw2DImage(images, new position2di(270, 105),
                        (time / 500 % 2) == 1 ? imp1 : imp2, null,
                        new SColor(255, (time) % 255, 255, 255), true);

                    /*
                    Drawing text is really simple. The code should be self
                    explanatory.
                    */

                    // draw some text
                    if (font != null)
                        font.draw("This demo shows that Irrlicht is also capable of drawing 2D graphics.",
                            new recti(130, 10, 300, 50),
                            new SColor(255, 255, 255, 255));

                    // draw some other text
                    if (font2 != null)
                        font2.draw("Also mixing with 3d graphics is possible.",
                            new recti(130, 20, 300, 60),
                            new SColor(255, time % 255, time % 255, 255));

                    /*
                    At last, we draw the Irrlicht Engine logo (without
                    using a color or an alpha channel) and a transparent 2d
                    Rectangle at the position of the mouse cursor.
                    */

                    // draw logo
                    driver.draw2DImage(images, new position2di(10, 10),
                        new recti(354, 87, 442, 118));

                    // draw transparent rect under cursor
                    position2di m = device.getCursorControl().getPosition();
                    driver.draw2DRectangle(new SColor(100, 255, 255, 255),
                        new recti(m.X - 20, m.Y - 20, m.X + 20, m.Y + 20));

                    driver.endScene();
                }
            }

            return;
        }
    }
}
