#ifndef IFILE_READ_CALLBACK_FOR_INHERITANCE_H
#define IFILE_READ_CALLBACK_FOR_INHERITANCE_H

#include "irrXML.h"

class IFileReadCallBack_ForInheritance : public irr::io::IFileReadCallBack
{
public:

	//! Destructor
	virtual ~IFileReadCallBack_ForInheritance() {}

	int read(void* buffer, int sizeToRead)
	{
		irr::core::array<unsigned char> arr;
		arr.set_pointer((unsigned char*)buffer, sizeToRead);
		return read(&arr, sizeToRead);
	}
	
	virtual int read(irr::core::array<unsigned char>* buffer, int sizeToRead) = 0;

	//! Returns size of file in bytes
	virtual long getSize() const = 0;
};

#endif //IFILE_READ_CALLBACK_FOR_INHERITANCE_H