﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IrrlichtNetSwig
{
    public partial class IVideoDriver
    {
        public virtual void drawStencilShadowVolume(vector3df[] triangles, int count, bool zfail)
        {
            vector3dfArray arr = (vector3dfArray)triangles;
            drawStencilShadowVolume(arr.cast(), count, zfail);
        }

        public virtual void drawStencilShadowVolume(vector3df[] triangles, int count)
        {
            vector3dfArray arr = (vector3dfArray)triangles;
            drawStencilShadowVolume(arr.cast(), count);
        }

        public virtual void drawIndexedTriangleList(S3DVertex[] vertices, uint vertexCount, ushort[] indexList, uint triangleCount)
        {
            S3DVertexArray arr = (S3DVertexArray)vertices;
            drawIndexedTriangleList(arr.cast(), vertexCount, indexList, triangleCount);
        }

        public virtual void drawIndexedTriangleList(S3DVertex2TCoords[] vertices, uint vertexCount, ushort[] indexList, uint triangleCount)
        {
            S3DVertex2TCoordsArray arr = (S3DVertex2TCoordsArray)vertices;
            drawIndexedTriangleList(arr.cast(), vertexCount, indexList, triangleCount);
        }


        public virtual void drawIndexedTriangleList(S3DVertexTangents[] vertices, uint vertexCount, ushort[] indexList, uint triangleCount)
        {
            S3DVertexTangentsArray arr = (S3DVertexTangentsArray)vertices;
            drawIndexedTriangleList(arr.cast(), vertexCount, indexList, triangleCount);
        }

        public void drawVertexPrimitiveList(S3DVertex[] vertices, uint vertexCount, int[] indexList, uint primCount, E_VERTEX_TYPE vType, E_PRIMITIVE_TYPE pType, E_INDEX_TYPE iType)
        {
            S3DVertexArray arr = (S3DVertexArray)vertices;
            drawVertexPrimitiveList(arr.cast(), vertexCount, indexList, primCount, vType, pType, iType);
        }

        public void drawVertexPrimitiveList(S3DVertex2TCoords[] vertices, uint vertexCount, int[] indexList, uint primCount, E_VERTEX_TYPE vType, E_PRIMITIVE_TYPE pType, E_INDEX_TYPE iType)
        {
            S3DVertex2TCoordsArray arr = (S3DVertex2TCoordsArray)vertices;
            drawVertexPrimitiveList(arr.cast(), vertexCount, indexList, primCount, vType, pType, iType);
        }

        public void drawVertexPrimitiveList(S3DVertexTangents[] vertices, uint vertexCount, int[] indexList, uint primCount, E_VERTEX_TYPE vType, E_PRIMITIVE_TYPE pType, E_INDEX_TYPE iType)
        {
            S3DVertexTangentsArray arr = (S3DVertexTangentsArray)vertices;
            drawVertexPrimitiveList(arr.cast(), vertexCount, indexList, primCount, vType, pType, iType);
        }

    }
}
