﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IrrlichtNetSwig
{
    public partial class arraySSkinMeshBuffer
    {
        public SSkinMeshBuffer this[uint index]
        {
            get
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                return getValue(index);
            }
            set
            {
                if (index < 0 || size() < index)
                {
                    throw new System.IndexOutOfRangeException();
                }
                setValue(index, value);
            }
        }
        public static implicit operator arraySSkinMeshBuffer(SSkinMeshBuffer[] other)
        {
            var arr = new arraySSkinMeshBuffer((uint)other.Length);
            for (uint i = 0; i < other.Length; i++)
            {
                arr.push_back(other[i]);
            }
            return arr;
        }
        public SSkinMeshBuffer[] ToArray()
        {
            var arr = new SSkinMeshBuffer[size()];
            for (uint i = 0; i < size(); i++)
            {
                arr[i] = this.getValue(i);
            }
            return arr;
        }
    }
}
