﻿using System;
using System.Collections.Generic;
using System.Text;
using IrrlichtNetSwig;

namespace Quake3Map
{
    class Program
    {
        static void Main(string[] args)
        {
           	IrrlichtDevice device = IrrlichtNet.createDevice(E_DRIVER_TYPE.EDT_DIRECT3D9, new dimension2dui(640, 480));

	        IVideoDriver driver = device.getVideoDriver();
	        ISceneManager smgr = device.getSceneManager();

	        device.getFileSystem().addZipFileArchive("../../media/map-20kdm2.pk3");

	        IAnimatedMesh mesh = smgr.getMesh("20kdm2.bsp");
	        ISceneNode node = null;
	
	        if (mesh!=null)
	        {
	            node = smgr.addOctTreeSceneNode(mesh.getMesh(0), null, -1, 1024);
	        }
 

        	if (node!=null)
        	{
        	    node.setPosition(new vector3df(-1300, -144, -1249));
        	}

        	smgr.addCameraSceneNodeFPS();

        	device.getCursorControl().setVisible(false);
        	int lastFPS = -1;

	        while(device.run())
	        {
                if (device.isWindowActive())
                {
                    driver.beginScene(true, true, new SColor(255, 200, 200, 200));
                    smgr.drawAll();
                    driver.endScene();

                    int fps = driver.getFPS();

                    if (lastFPS != fps)
                    {
                        string str = "Irrlicht Engine - Quake 3 Map example [";
                        str += driver.getName();
                        str += "] FPS:";
                        str += fps;

                        device.setWindowCaption(str);
                        lastFPS = fps;
                    }
                }
                else
                {
                    device.yield();
                }
	        }

        }
    }
}
