﻿using System;
using System.Collections.Generic;
using System.Text;
using IrrlichtNetSwig;

namespace Quake3Explorer
{
    //! Defines to which group the entities belong
    public enum eItemGroup
    {
	    WEAPON,
	    AMMO,
	    ARMOR,
	    HEALTH,
	    POWERUP
    }

    //! define a supgroup for the item. for e.q the Weapons
    public enum eItemSubGroup
    {
	    SUB_NONE = 0,
	    GAUNTLET,
	    MACHINEGUN,
	    SHOTGUN,
	    GRENADE_LAUNCHER,
	    ROCKET_LAUNCHER,
	    LIGHTNING,
	    RAILGUN,
	    PLASMAGUN,
	    BFG,
	    GRAPPLING_HOOK,
	    NAILGUN,
	    PROX_LAUNCHER,
	    CHAINGUN,
    }

    //! aplly a special effect to the shader
    public enum eItemSpecialEffect
    {
	    SPECIAL_SFX_NONE		= 0,
	    SPECIAL_SFX_ROTATE		= 1,
	    SPECIAL_SFX_BOUNCE		= 2,
	    SPECIAL_SFX_ROTATE_1	= 4,
    }

    // a List for defining a model
    public class SItemElement
    {
	    public string key;
        public string[] model;
        public string sound;
        public string icon;
        public string pickup;
        public int value;
        public eItemGroup group;
        public eItemSubGroup sub;
        public int special;
        public SItemElement()
        {
            model = new string[2];
        }
    }

    public class Q3Factory
    {
        static SItemElement[] Quake3ItemElement = new SItemElement[]
        {
            new SItemElement(){
                key="item_health",
	            model = new string[]{ "models/powerups/health/medium_cross.md3",
	                                  "models/powerups/health/medium_sphere.md3"},
	            sound = "sound/items/n_health.wav",
	            icon = "icons/iconh_yellow",
	            pickup = "25 Health",
	            value = 25,
	            group = eItemGroup.HEALTH,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE | (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE_1 
            },
            new SItemElement()
            {
                key="item_health_large",
	            model = new string[]{ "models/powerups/health/large_cross.md3",
	                                  "models/powerups/health/large_sphere.md3"},
	            sound = "sound/items/l_health.wav",
	            icon = "icons/iconh_red",
	            pickup = "50 Health",
	            value = 50,
	            group = eItemGroup.HEALTH,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE | (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE_1
            },
            new SItemElement()
            {
	            key="item_health_mega",
	            model = new string[]{ "models/powerups/health/mega_cross.md3",
	                                  "models/powerups/health/mega_sphere.md3"},
	            sound = "sound/items/m_health.wav",
	            icon = "icons/iconh_mega",
	            pickup = "Mega Health",
	            value = 100,
	            group = eItemGroup.HEALTH,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE | (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE_1
            },
            new SItemElement()
            {
	            key="item_health_small",
	            model = new string[]{ "models/powerups/health/small_cross.md3",
	                                  "models/powerups/health/small_sphere.md3"},
	            sound = "sound/items/s_health.wav",
	            icon = "icons/iconh_green",
	            pickup = "5 Health",
	            value = 5,
	            group = eItemGroup.HEALTH,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE | (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE_1
            },
            new SItemElement()
            {	key="ammo_bullets",
	            model = new string[]{ "models/powerups/ammo/machinegunam.md3",
	                                  ""},
	            sound = "sound/misc/am_pkup.wav",
	            icon = "icons/icona_machinegun",
	            pickup = "Bullets",
	            value = 50,
	            group = eItemGroup.AMMO,
	            sub = eItemSubGroup.MACHINEGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE,
            },
            new SItemElement()
            {
	            key="ammo_cells",
	            model = new string[]{ "models/powerups/ammo/plasmaam.md3",
	                                  ""},
	            sound = "sound/misc/am_pkup.wav",
	            icon = "icons/icona_plasma",
	            pickup = "Cells",
	            value = 30,
	            group = eItemGroup.AMMO,
	            sub = eItemSubGroup.PLASMAGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE
            },
            new SItemElement()
            {	key="ammo_rockets",
	            model = new string[]{ "models/powerups/ammo/rocketam.md3",
	                                  ""},
	            sound = "",
	            icon = "icons/icona_rocket",
	            pickup = "Rockets",
	            value = 5,
	            group = eItemGroup.AMMO,
	            sub = eItemSubGroup.ROCKET_LAUNCHER,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="ammo_shells",
	            model = new string[]{ "models/powerups/ammo/shotgunam.md3",
	                                  ""},
	            sound = "sound/misc/am_pkup.wav",
	            icon = "icons/icona_shotgun",
	            pickup = "Shells",
	            value = 10,
	            group = eItemGroup.AMMO,
	            sub = eItemSubGroup.SHOTGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="ammo_slugs",
	            model = new string[]{ "models/powerups/ammo/railgunam.md3",
	                                  ""},
	            sound = "sound/misc/am_pkup.wav",
	            icon = "icons/icona_railgun",
	            pickup = "Slugs",
	            value = 10,
	            group = eItemGroup.AMMO,
	            sub = eItemSubGroup.RAILGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="item_armor_body", 
	            model = new string[]{ "models/powerups/armor/armor_red.md3",
	                                  ""},
	            sound = "sound/misc/ar2_pkup.wav",
	            icon = "icons/iconr_red",
	            pickup = "Heavy Armor",
	            value = 100,
	            group = eItemGroup.ARMOR,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="item_armor_combat", 
	            model = new string[]{ "models/powerups/armor/armor_yel.md3",
	                                  ""},
	            sound = "sound/misc/ar2_pkup.wav",
	            icon = "icons/iconr_yellow",
	            pickup = "Armor",
	            value = 50,
	            group = eItemGroup.ARMOR,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="item_armor_shard", 
	            model = new string[]{ "models/powerups/armor/shard.md3",
	                                  ""},
	            sound = "sound/misc/ar1_pkup.wav",
	            icon = "icons/iconr_shard",
	            pickup = "Armor Shared",
	            value = 5,
	            group = eItemGroup.ARMOR,
	            sub = eItemSubGroup.SUB_NONE,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_gauntlet", 
	            model = new string[]{ "models/weapons2/gauntlet/gauntlet.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_gauntlet",
	            pickup = "Gauntlet",
	            value = 0,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.GAUNTLET,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_shotgun", 
	            model = new string[]{ "models/weapons2/shotgun/shotgun.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_shotgun",
	            pickup = "Shotgun",
	            value = 10,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.SHOTGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_machinegun", 
	            model = new string[]{ "models/weapons2/machinegun/machinegun.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_machinegun",
	            pickup = "Machinegun",
	            value = 40,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.MACHINEGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_grenadelauncher",
	            model = new string[]{ "models/weapons2/grenadel/grenadel.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_grenade",
	            pickup = "Grenade Launcher",
	            value = 10,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.GRENADE_LAUNCHER,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_rocketlauncher",
	            model = new string[]{ "models/weapons2/rocketl/rocketl.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_rocket",
	            pickup = "Rocket Launcher",
	            value = 10,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.ROCKET_LAUNCHER,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_lightning", 
	            model = new string[]{ "models/weapons2/lightning/lightning.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_lightning",
	            pickup = "Lightning Gun",
	            value = 100,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.LIGHTNING,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_railgun", 
	            model = new string[]{ "models/weapons2/railgun/railgun.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_railgun",
	            pickup = "Railgun",
	            value = 10,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.RAILGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_plasmagun", 
	            model = new string[]{ "models/weapons2/plasma/plasma.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_plasma",
	            pickup = "Plasma Gun",
	            value = 50,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.PLASMAGUN,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_bfg",
	            model = new string[]{ "models/weapons2/bfg/bfg.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_bfg",
	            pickup = "BFG10K",
	            value = 20,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.BFG,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            },
            new SItemElement()
            {
	            key="weapon_grapplinghook",
	            model = new string[]{ "models/weapons2/grapple/grapple.md3",
	                                  ""},
	            sound = "sound/misc/w_pkup.wav",
	            icon = "icons/iconw_grapple",
	            pickup = "Grappling Hook",
	            value = 0,
	            group = eItemGroup.WEAPON,
	            sub = eItemSubGroup.GRAPPLING_HOOK,
	            special = (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE
            }
        };



        //! Get's an entity based on it's key
        public static SItemElement getItemElement(string key)
        {
            foreach (SItemElement item in Quake3ItemElement)
            {
                if (key == item.key)
                {
                    return item;
                }
            }
            return new SItemElement();
        }

        /*!
	        Quake3 Model Factory.
	        Takes the mesh buffers and creates scenenodes for their associated shaders
        */
        public static void Q3ShaderFactory(Q3LevelLoadParameter loadParam,
                                IrrlichtDevice device,
                                IQ3LevelMesh mesh,
                                eQ3MeshIndex meshIndex,
                                ISceneNode parent,
                                IMetaTriangleSelector meta,
                                bool showShaderName
                            )
        {
            if (null == mesh || null == device)
            {
                return;
            }

            IMeshSceneNode node = null;
            ISceneManager smgr = device.getSceneManager();
            ITriangleSelector selector = null;

            // the additional mesh can be quite huge and is unoptimized
            // Save to cast to SMesh
            SMesh additional_mesh = SMesh.cast(mesh.getMesh((int)meshIndex));
            if (null == additional_mesh || additional_mesh.getMeshBufferCount() == 0)
            {
                return;
            }

            string buf;
            if (loadParam.verbose > 0)
            {
                loadParam.startTime = device.getTimer().getRealTime();
                if (loadParam.verbose > 1)
                {
                    buf = "q3shaderfactory start";
                    device.getLogger().log(buf, ELOG_LEVEL.ELL_INFORMATION);
                }
            }

            IGUIFont font = null;
            if (showShaderName)
            {
                font = device.getGUIEnvironment().getFont("fontlucida.png");
            }

            IVideoDriver driver = device.getVideoDriver();

            // create helper textures
            {
                arrayTexture tex = new arrayTexture();
                uint pos = 0;
                IrrlichtNet.getTextures(tex, "$redimage $blueimage $whiteimage $checkerimage", ref pos,
                                        device.getFileSystem(), driver);
            }

            int sceneNodeID = 0;
            for (uint i = 0; i != additional_mesh.getMeshBufferCount(); ++i)
            {
                IMeshBuffer meshBuffer = additional_mesh.getMeshBuffer(i);
                SMaterial material = meshBuffer.getMaterial();

                //! The ShaderIndex is stored in the second material parameter
                int shaderIndex = (int)material.MaterialTypeParam2;

                // the meshbuffer can be rendered without additional support, or it has no shader
                IShader shader = mesh.getShader((uint)shaderIndex);

                // no shader, or mapped to existing material
                if (null == shader)
                {
                    // clone mesh
                    SMesh m = new SMesh();
                    m.addMeshBuffer(meshBuffer);
                    SMaterial mat = m.getMeshBuffer(0).getMaterial();
                    if (mat.getTexture(0) == null)
                    {
                        mat.setTexture(0, driver.getTexture("$blueimage"));
                    }
                    if (mat.getTexture(1) == null)
                    {
                        mat.setTexture(1, driver.getTexture("$redimage"));
                    }

                    IMesh store = smgr.getMeshManipulator().createMeshWith2TCoords(m);
                    //m.drop();

                    node = smgr.addMeshSceneNode(store, parent, sceneNodeID);
                    node.setAutomaticCulling(E_CULLING_TYPE.EAC_OFF);
                    //store->drop ();
                    sceneNodeID += 1;
                }
                else
                {
                    // create sceneNode
                    node = smgr.addQuake3SceneNode(meshBuffer, shader, parent, sceneNodeID);
                    node.setAutomaticCulling(E_CULLING_TYPE.EAC_FRUSTUM_BOX);
                    sceneNodeID += 1;
                }

                // show Debug Shader Name
                if (showShaderName && node != null)
                {
                    IBillboardTextSceneNode node2 = null;
                    buf = string.Format("{0};{1}", node.getName(), node.getID());
                    node2 = smgr.addBillboardTextSceneNode(
                            font,
                            buf,
                            node,
                            new dimension2df(80.0f, 8.0f),
                            new vector3df(0, 10, 0),
                            sceneNodeID
                            );
                    buf = string.Format("{0};{1}", node.getName(), node.getID());
                    //node2->setName ( buf );
                    sceneNodeID += 1;
                }

                // create Portal Rendertargets
                if (shader != null)
                {
                    SVarGroup group = shader.getGroup(1);
                    if (group.isDefined("surfaceparm", "portal") != 0)
                    {
                    }

                }


                // add collision
                // find out if shader is marked als nonsolid
                bool doCreate = meta != null;

                if (shader != null)
                {
                    SVarGroup group = shader.getGroup(1);
                    if (group.isDefined("surfaceparm", "trans") != 0
                        // || group->isDefined( "surfaceparm", "sky" )
                        // || group->isDefined( "surfaceparm", "nonsolid" )
                        )
                    {
                        if (group.isDefined("surfaceparm", "metalsteps") == 0)
                        {
                            doCreate = false;
                        }
                    }
                }

                if (doCreate)
                {
                    IMesh m = null;

                    //! controls if triangles are modified by the scenenode during runtime
                    bool takeOriginal = true;

                    if (takeOriginal)
                    {
                        m = new SMesh();
                        SMesh.cast(m).addMeshBuffer(meshBuffer);
                    }
                    else
                    {
                        m = node.getMesh();
                    }

                    //selector = smgr->createOctTreeTriangleSelector ( m, 0, 128 );
                    selector = smgr.createTriangleSelector(m, null);
                    meta.addTriangleSelector(selector);
                    //selector.drop ();

                    if (takeOriginal)
                    {
                        //delete m;
                    }
                }

            }

            if (loadParam.verbose > 0)
            {
                loadParam.endTime = device.getTimer().getRealTime();
                buf = string.Format("q3shaderfactory needed {0:D4} ms to create {1} shader nodes",
                            loadParam.endTime - loadParam.startTime, sceneNodeID);
                device.getLogger().log(buf, ELOG_LEVEL.ELL_INFORMATION);
            }
        }


        /*!
	        Creates Model based on the entity list
        */
        public static void Q3ModelFactory(Q3LevelLoadParameter loadParam,
                                IrrlichtDevice device,
                                IQ3LevelMesh masterMesh,
                                ISceneNode parent,
                                bool showShaderName
                            )
        {
            if (null == masterMesh)
                return;

            tQ3EntityList entity = masterMesh.getEntityList();
            ISceneManager smgr = device.getSceneManager();


            string buf;
            SVarGroup group;
            IShader search = new IShader();
            int index = 0;
            int lastIndex = 0;

            IAnimatedMeshMD3 model;
            SMD3Mesh mesh;
            SMD3MeshBuffer meshBuffer;
            IMeshSceneNode node;
            ISceneNodeAnimator anim;
            IShader shader;
            uint pos;
            vector3df p = new vector3df();
            uint nodeCount = 0;
            arrayTexture textureArray;

            IGUIFont font = null;
            if (showShaderName)
            {
                font = device.getGUIEnvironment().getFont("fontlucida.png");
            }

            SItemElement itemElement;

            // walk list
            for (index = 0; (uint)index < entity.size(); ++index)
            {
                itemElement = getItemElement(entity[(uint)index].name.ToString());
                if (null == itemElement)
                    continue;

                pos = 0;
                p = IrrlichtNet.getAsVector3df(entity[(uint)index].getGroup(1).get("origin"), ref pos);

                nodeCount += 1;
                for (uint g = 0; g < 2; ++g)
                {
                    if (null == itemElement.model[g] || itemElement.model[g].Length == 0)
                        continue;
                    model = IAnimatedMeshMD3.cast(smgr.getMesh(itemElement.model[g]));
                    if (null == model)
                        continue;

                    mesh = model.getOriginalMesh();
                    for (uint j = 0; j != mesh.Buffer.size(); ++j)
                    {
                        meshBuffer = mesh.Buffer[j];
                        if (null == meshBuffer)
                            continue;

                        shader = masterMesh.getShader(meshBuffer.Shader.ToString(), false);
                        IMeshBuffer final = model.getMesh(0).getMeshBuffer(j);
                        if (shader != null)
                        {
                            //!TODO: Hack don't modify the vertexbuffer. make it better;-)
                            final.getMaterial().ColorMask = 0;
                            node = smgr.addQuake3SceneNode(final, shader, parent);
                            final.getMaterial().ColorMask = 15;
                        }
                        else
                        {
                            // clone mesh
                            SMesh m = new SMesh();
                            m.addMeshBuffer(final);
                            node = smgr.addMeshSceneNode(m, parent);
                            //m.drop();
                        }

                        if (null == node)
                        {
                            buf = string.Format("q3ModelFactory shader {0} failed", meshBuffer.Shader.ToString());
                            device.getLogger().log(buf);
                            continue;
                        }

                        // node was maybe centered by shaderscenenode
                        node.setPosition(p);
                        node.setName(meshBuffer.Shader);
                        node.setAutomaticCulling(E_CULLING_TYPE.EAC_BOX);

                        // add special effects to node
                        if ((itemElement.special & (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE) != 0 ||
                                (g == 0 && (itemElement.special & (int)eItemSpecialEffect.SPECIAL_SFX_ROTATE_1) != 0)
                            )
                        {
                            anim = smgr.createRotationAnimator(new vector3df(0.0f, 2.0f, 0.0f));
                            node.addAnimator(anim);
                            //anim->drop ();
                        }

                        if ((itemElement.special & (int)eItemSpecialEffect.SPECIAL_SFX_BOUNCE) != 0)
                        {
                            //anim = smgr->createFlyStraightAnimator ( 
                            //	p, p + vector3df ( 0.f, 60.f, 0.f ), 1000, true, true );
                            anim = smgr.createFlyCircleAnimator(
                                p + new vector3df(0.0f, 20.0f, 0.0f),
                                20.0f,
                                0.005f,
                                new vector3df(1.0f, 0.0f, 0.0f),
                                IrrlichtNet.fract(nodeCount * 0.05f),
                                1.0f
                                );
                            node.addAnimator(anim);
                            //anim->drop ();
                        }
                    }
                }
                // show name
                if (showShaderName)
                {
                    IBillboardTextSceneNode node2 = null;
                    buf = itemElement.key;
                    node2 = smgr.addBillboardTextSceneNode(
                            font,
                            buf,
                            parent,
                            new dimension2df(80.0f, 8.0f),
                            p + new vector3df(0, 30, 0),
                            0
                            );
                }

            }

            // music
            search.name = "worldspawn";
            index = entity.binary_search_multi(search, ref lastIndex);

            if (index >= 0)
            {
                group = entity[(uint)index].getGroup(1);
                Sound.background_music(group.get("music").c_str());
            }

            // music
            search.name = "worldspawn";
            index = entity.binary_search_multi(search, ref lastIndex);

            if (index >= 0)
            {
                group = entity[(uint)index].getGroup(1);
                Sound.background_music(group.get("music").c_str());
            }

            //IAnimatedMesh* mesh = smgr->getMesh("../../media/sydney.md2");
            //IAnimatedMeshSceneNode* node = smgr->addAnimatedMeshSceneNode( mesh );

        }

        /*!
	        so we need a good starting Position in the level.
	        we can ask the Quake3 Loader for all entities with class_name "info_player_deathmatch"
        */
        public static int Q3StartPosition(IQ3LevelMesh mesh,
                                ICameraSceneNode camera,
                                int startposIndex,
                                vector3df translation
                            )
        {
            if (null == mesh)
                return 0;

            tQ3EntityList entityList = mesh.getEntityList();

            IShader search = new IShader();
            search.name = "info_player_start";	// "info_player_deathmatch";

            // find all entities in the multi-list
            int lastIndex = 0;
            int index = entityList.binary_search_multi(search, ref lastIndex);

            if (index < 0)
            {
                search.name = "info_player_deathmatch";
                index = entityList.binary_search_multi(search, ref lastIndex);
            }

            if (index < 0)
            {
                return 0;
            }

            index += clamp(startposIndex, 0, lastIndex - index);

            uint parsepos;

            SVarGroup group;
            group = entityList[(uint)index].getGroup(1);

            parsepos = 0;
            vector3df pos = IrrlichtNet.getAsVector3df(group.get("origin"), ref parsepos);
            pos += translation;

            parsepos = 0;
            float angle = IrrlichtNet.getAsFloat(group.get("angle"), ref parsepos);

            vector3df target = new vector3df(0.0f, 0.0f, 1.0f);
            target.rotateXZBy(angle - 90.0f, new vector3df());

            if (camera != null)
            {
                camera.setPosition(pos);
                camera.setTarget(pos + target);
                //! New. FPSCamera and animators catches reset on animate 0
                camera.OnAnimate(0);
            }
            return lastIndex - index + 1;
        }
        public static int clamp(int value, int min, int max)
        {
            return Math.Min(Math.Max(value, min), max);
        }
        /*!
	        gets a accumulated force on a given surface
        */
        public static vector3df getGravity(string surface)
        {
            if (surface == "earth") return new vector3df(0.0f, -90.0f, 0.0f);
            if (surface == "moon") return new vector3df(0.0f, -6.0f / 100.0f, 0.0f);
            if (surface == "water") return new vector3df(0.1f / 100.0f, -2.0f / 100.0f, 0.0f);
            if (surface == "ice") return new vector3df(0.2f / 100.0f, -9.0f / 100.0f, 0.3f / 100.0f);

            return new vector3df(0.0f, 0.0f, 0.0f);
        }


        /*
	        Dynamically load the Irrlicht Library
        */
        /*
        funcptr_createDevice load_createDevice ( string filename)
        {
        }
        funcptr_createDeviceEx load_createDeviceEx ( string filename)
        {
        }
        */

        //! Macro for save Dropping an Element
        public static void dropElement(ISceneNode x)
        {
            if (x != null)
            {
                x.remove();
                x = null;
            }
        }
        public static void dropElement(IGUIElement x)
        {
            if (x != null)
            {
                x.remove();
                x = null;
            }
        }


        /*
	        get the current collision respone camera animator
        */
        public static ISceneNodeAnimatorCollisionResponse camCollisionResponse(IrrlichtDevice device)
        {
            ICameraSceneNode camera = device.getSceneManager().getActiveCamera();
            ISceneNodeAnimatorCollisionResponse a = null;

            listSceneNodeAnimator list = camera.getAnimators();
            foreach (ISceneNodeAnimator item in list)
            {
                a = ISceneNodeAnimatorCollisionResponse.cast(item);
                ESCENE_NODE_ANIMATOR_TYPE test = a.getType();
                if (a.getType() == ESCENE_NODE_ANIMATOR_TYPE.ESNAT_COLLISION_RESPONSE)
                {
                    return a;
                }
            }

            return null;
        }



        public static void setTimeFire(TimeFire t, uint delta, uint flags)
        {
            t.flags = flags;
            t.next = 0;
            t.delta = delta;
        }
        public static void checkTimeFire(TimeFire[] t, uint listSize, uint now)
        {
            uint i;
            for (i = 0; i < listSize; ++i)
            {
                if (now < t[i].next)
                    continue;

                t[i].next = Math.Max(now + t[i].delta, t[i].next + t[i].delta);
                t[i].flags |= (uint)eTimeFireFlag.FIRED;
            }
        }
    }
   
    //! internal Animation
    public enum eTimeFireFlag
    {
        FIRED = 1,
    }

    public struct TimeFire
    {
        public uint flags;
        public uint next;
        public uint delta;
    }
}
