#ifndef __I_GUI_ELEMENT_FOR_INHERITANCE_H_INCLUDED__
#define __I_GUI_ELEMENT_FOR_INHERITANCE_H_INCLUDED__

#include "IGUIElement.h"

namespace irr
{
namespace gui
{

class IGUIElement_ForInheritance : public IGUIElement
{
public:

	//! Constructor
	IGUIElement_ForInheritance(EGUI_ELEMENT_TYPE type, IGUIEnvironment* environment, IGUIElement* parent,
		s32 id, const core::rect<s32>& rectangle)
		: IGUIElement(type, environment, parent, id, rectangle)
	{
		
	}
	virtual void serializeAttributes(io::IAttributes* outObj, io::SAttributeReadWriteOptions* options=0) const
	{
		IGUIElement::serializeAttributes(outObj, options);
	}
	virtual void deserializeAttributes(io::IAttributes* inObj, io::SAttributeReadWriteOptions* options=0)
	{
		IGUIElement::deserializeAttributes(inObj, options);
	}
	//! Called if an event happened.
	virtual bool OnEvent2(const SEvent& ev){return false;}
	
	virtual bool OnEvent(const SEvent& ev)
	{
		return OnEvent2(ev);
	}

	//! Updates the absolute position.
	virtual void updateAbsolutePosition()
	{
		IGUIElement::updateAbsolutePosition();
	}

	//! Returns true if a point is within this element.
	/** Elements with a shape other than a rectangle should override this method */
	virtual bool isPointInside(const core::position2d<s32>& point) const
	{
		return IGUIElement::isPointInside(point);
	}


	//! Adds a GUI element as new child of this element.
	virtual void addChild(IGUIElement* child)
	{
		IGUIElement::addChild(child);
	}

	//! Removes a child.
	virtual void removeChild(IGUIElement* child)
	{
		IGUIElement::removeChild(child);
	}


	//! Removes this element from its parent.
	virtual void remove()
	{
		IGUIElement::remove();
	}


	//! Draws the element and its children.
	virtual void draw()
	{
		IGUIElement::draw();
	}


	//! animate the element and its children.
	virtual void OnPostRender(u32 timeMs)
	{
		IGUIElement::OnPostRender(timeMs);
	}


	//! Moves this element.
	virtual void move(core::position2d<s32> absoluteMovement)
	{
		IGUIElement::move(absoluteMovement);
	}


	//! Returns true if element is visible.
	virtual bool isVisible() const
	{
		return IGUIElement::isVisible();
	}


	//! Sets the visible state of this element.
	virtual void setVisible(bool visible)
	{
		IGUIElement::setVisible(visible);
	}


	//! Returns true if this element was created as part of its parent control
	virtual bool isSubElement() const
	{
		return IGUIElement::isSubElement();
	}


	//! Sets whether this control was created as part of its parent.
	/** For example, it is true when a scrollbar is part of a listbox.
	SubElements are not saved to disk when calling guiEnvironment->saveGUI() */
	virtual void setSubElement(bool subElement)
	{
		IGUIElement::setSubElement(subElement);
	}


	//! Returns true if element is enabled.
	virtual bool isEnabled() const
	{
		return IGUIElement::isEnabled();
	}


	//! Sets the enabled state of this element.
	virtual void setEnabled(bool enabled)
	{
		IGUIElement::setEnabled(enabled);
	}


	//! Sets the new caption of this element.
	virtual void setText(const wchar_t* text)
	{
		IGUIElement::setText(text);
	}


	//! Returns caption of this element.
	virtual const wchar_t* getText() const
	{
		return IGUIElement::getText();
	}


	//! Sets the new caption of this element.
	virtual void setToolTipText(const wchar_t* text)
	{
		IGUIElement::setToolTipText(text);
	}


	//! Returns caption of this element.
	virtual const core::stringw& getToolTipText() const
	{
		return IGUIElement::getToolTipText();
	}


	//! Returns id. Can be used to identify the element.
	virtual s32 getID() const
	{
		return IGUIElement::getID();
	}


	//! Sets the id of this element
	virtual void setID(s32 id)
	{
		IGUIElement::setID(id);
	}

	//! Brings a child to front
	/** \return True if successful, false if not. */
	virtual bool bringToFront(IGUIElement* element)
	{
		return IGUIElement::bringToFront(element);
	}


	//! Returns list with children of this element
	virtual const core::list<IGUIElement*>& getChildren() const
	{
		return IGUIElement::getChildren();
	}


	//! Finds the first element with the given id.
	/** \param id: Id to search for.
	\param searchchildren: Set this to true, if also children of this
	element may contain the element with the searched id and they
	should be searched too.
	\return Returns the first element with the given id. If no element
	with this id was found, 0 is returned. */
	virtual IGUIElement* getElementFromId(s32 id, bool searchchildren=false) const
	{
		return IGUIElement::getElementFromId(id, searchchildren);
	}

	//! Returns true if the gui element supports the given type.
	/** This is mostly used to check if you can cast a gui element to the class that goes with the type.
	Most gui elements will only support their own type, but if you derive your own classes from interfaces
	you can overload this function and add a check for the type of the base-class additionally.
	This allows for checks comparable to the dynamic_cast of c++ with enabled rtti.
	Note that you can't do that by calling BaseClass::hasType(type), but you have to do an explicit
	comparison check, because otherwise the base class usually just checks for the membervariable
	Type which contains the type of your derived class.
	*/
	virtual bool hasType(EGUI_ELEMENT_TYPE type) const
	{
		return IGUIElement::hasType(type);
	}


	//! Returns the type name of the gui element.
	/** This is needed serializing elements. For serializing your own elements, override this function
	and return your own type name which is created by your IGUIElementFactory */
	virtual const c8* getTypeName() const
	{
		return IGUIElement::getTypeName();
	}
};


} // end namespace gui
} // end namespace irr

#endif

