﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace IrrlichtNetSwig
{
    class WrapperObjectDisposer
    {
        static List<DosposerClass> Classes { get; set; }

        static WrapperObjectDisposer()
        {
            Classes = new List<DosposerClass>();

            Type[] allTypes = System.Reflection.Assembly.GetExecutingAssembly().GetTypes();
            foreach (var type in allTypes)
            {
                MethodInfo method = type.GetMethod("drop", BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
                if (method != null)
                {
                    Classes.Add(new DosposerClass(method, type));
                }
            }
        }
        internal static void Drop(object obj)
        {
            foreach (DosposerClass cls in Classes)
            {
                if (cls.ClassType.IsAssignableFrom(obj.GetType()))
                {
                    cls.InvokeDrop(obj);
                    break;
                }
            }
        }

        internal static bool IsNeedDrop(object obj)
        {
            foreach (DosposerClass cls in Classes)
            {
                if (cls.ClassType.IsAssignableFrom(obj.GetType()))
                {
                    return true;
                }
            }
            return false;
        }
    }

    class DosposerClass
    {
        readonly MethodInfo _method;
        readonly Type _type;
        internal DosposerClass(MethodInfo method, Type type)
        {
            _method = method;
            _type = type;
        }
        internal void InvokeDrop(object obj)
        {
            _method.Invoke(obj, new object[0]);
        }
        internal Type ClassType { get { return _type; } }
    }
}
