﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Commons.Collections;
using NVelocity.App;
using NVelocity;

namespace CreatePropertyCS
{
    class CSharpFileRepository
    {
        internal CSharpFileRepository(string templateFileName)
        {
            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);

            ExtendedProperties props = new ExtendedProperties();
            props.AddProperty("file.resource.loader.path", new System.Collections.ArrayList(new string[] { ".", dir }));
            Velocity.Init(props);
        }

        internal void Save(string filePath, ClassInfo clsInfo)
        {
            StreamWriter sw = new StreamWriter(filePath);

            //コンテキストの設定
            VelocityContext ctx = new VelocityContext();

            //クラスをセット
            ctx.Put("cls", clsInfo);

            //テンプレートファイルを読み込み、コンテキストとマージ
            Velocity.MergeTemplate("clsfiletemplate.vm",
                "UTF-8", ctx, sw);

            sw.Close();
        }
    }
}
