﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CreatePropertyCS
{
    class ClassInfo
    {
        public ClassInfo()
        {
            List = new PropInfoCollection();
        }
        public string Path { get; set; }

        public PropInfoCollection List{ get; set;}

        internal string GetFilePathWithhoutExtension()
        {
            string dir = System.IO.Path.GetDirectoryName(Path);
            string fileNameWithoutExtension = System.IO.Path.GetFileNameWithoutExtension(Path);
            return System.IO.Path.Combine(dir, fileNameWithoutExtension);
        }
        public string GetClassName()
        {
            return System.IO.Path.GetFileNameWithoutExtension(Path);
        }

        public bool IsEnable
        {
            get
            {
                foreach (var item in List)
                {
                    if (item.IsDisable == false)
                    {
                        return true;
                    }
                }
                return false;
            }
        }

        internal ClassInfo DeepCopy()
        {
            ClassInfo info = new ClassInfo();
            info.Path = this.Path;
            info.List = this.List.DeepCopy();
            return info;
        }

        internal ClassInfo Marge(ClassInfo clsInfo)
        {
            if (clsInfo == null)
            {
                return this;
            }
            var newCls = DeepCopy();

            newCls.List = newCls.List.Marge(clsInfo.List);
            return newCls;
        }
    }
}
