﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CreatePropertyCS
{
    class ClassInfoCollection : List<ClassInfo>
    {
        internal ClassInfo SearchOrCreateClass( string filePath)
        {
            var clsInfo = SearchClass(filePath);
            if (clsInfo != null)
            {
                return clsInfo;
            }
            clsInfo = new ClassInfo();
            clsInfo.Path = filePath;
            this.Add(clsInfo);
            return clsInfo;
        }

        internal PropInfo SearchOrCreateProperty(string name, string prefix, string type, string filePath)
        {
            var clsPath = this.SearchOrCreateClass(filePath);

            foreach (var propInfo in clsPath.List)
            {
                if (propInfo.Name == name &&
                    propInfo.Type == type)
                {
                    return propInfo;
                }
            }

            var info = new PropInfo();
            info.Name = name;
            info.Prefix = prefix;
            info.Type = type;
            clsPath.List.Add(info);
            return info;
        }

        internal ClassInfoCollection Marge(ClassInfoCollection list)
        {
            ClassInfoCollection result = DeepCopy();

            if (list == null)
            {
                return result;
            }

            foreach (var item in list)
            {
                ClassInfo cls = result.SearchClass(item.Path);
                if (cls != null)
                {
                    var classInfo = item.Marge(cls);
                    result.Remove(cls);
                    result.Add(classInfo);
                }
                else
                {
                    result.Add(item.DeepCopy());
                }
            }
            return result;
        }

        private ClassInfo SearchClass(string filePath)
        {
            foreach (var info in this)
            {
                if (info.Path == filePath)
                {
                    return info;
                }
            }
            return null;
        }

        internal ClassInfoCollection DeepCopy()
        {
            ClassInfoCollection list = new ClassInfoCollection();
            foreach (var item in this)
            {
                list.Add(item.DeepCopy());
            }
            return list;
        }

    }
}
