﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace CreatePropertyCS
{
    class IgnoreFileRepository
    {
        internal IgnoreFileRepository(string baseDir)
        {
            _baseDir = baseDir;
        }
        string _baseDir;
        Regex regex = new Regex(@"^(?<className>[a-zA-Z0-9_]+)\t(?<propertyName>[a-zA-Z0-9_]+)");
        internal ClassInfoCollection Load(string path)
        {
            ClassInfoCollection result = new ClassInfoCollection();

            StreamReader sr = new StreamReader(path);

            while (sr.EndOfStream==false)
            {
                string line = sr.ReadLine();
                if (regex.IsMatch(line))
                {
                    Match match = regex.Match(line);
                    string className = match.Groups["className"].Value;
                    string propertyName = match.Groups["propertyName"].Value;

                    PropInfo prop = result.SearchOrCreateProperty(propertyName, "", "", System.IO.Path.Combine(_baseDir, className+".cs"));
                    prop.IsDisable = true;
                }
            }
            sr.Close();

            return result;
        }
    }
}
