﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;

namespace CreatePropertyCS
{
    class PropertyParser
    {
        Regex regexGet = new Regex(@"public *(?<prefix>|(virtual)|( )) *(?<type>[a-zA-Z0-9_]+) +get(?<name>[a-zA-Z0-9_]+) *\( *\) *{", RegexOptions.Compiled);
        Regex regexSet = new Regex(@"public *(?<prefix>|(virtual)|( )) *void +set(?<name>[a-zA-Z0-9_]+)\( *(?<type>[a-zA-Z0-9_]+) +[a-zA-Z0-9_]+ *\) *{", RegexOptions.Compiled);
        Regex regexProperty = new Regex(@"public *(?<type>[a-zA-Z0-9_]+) *(?<name>[a-zA-Z0-9_]+) *{");

        internal ClassInfoCollection ParseCSFile(string filePath)
        {
            ClassInfoCollection list = new ClassInfoCollection();

            StreamReader sr = new StreamReader(filePath);
            while (sr.EndOfStream == false)
            {
                Match match;
                string line = sr.ReadLine();
                bool isGet = false;
                bool isSet = false;
                bool isDisable = false;
                if (regexGet.IsMatch(line))
                {
                    match = regexGet.Match(line);
                    isGet = true;
                }
                else if (regexSet.IsMatch(line))
                {
                    match = regexSet.Match(line);
                    isSet = true;
                }
                else if (regexProperty.IsMatch(line))
                {
                    match = regexProperty.Match(line);
                    isDisable = true;
                }
                else
                {
                    continue;
                }

                string propName = match.Groups["name"].Value;
                string propType = match.Groups["type"].Value;
                string propPrefix = match.Groups["prefix"].Value;
                PropInfo info = list.SearchOrCreateProperty(propName, propPrefix, propType, filePath);
                info.IsGet |= isGet;
                info.IsSet |= isSet;
                info.IsDisable |= isDisable;
            }
            sr.Close();


            //重複したプロパティとSetのみのPropertyを削除
            foreach (var clsInfo in list)
            {
                clsInfo.List = DeleteOverlapName(clsInfo.List);
                clsInfo.List = DeleteSetOnly(clsInfo.List);
                clsInfo.List = DeleteDisable(clsInfo.List);
            }

            list = DeleteEmptyClass(list);

            return list;
        }

        private ClassInfoCollection DeleteEmptyClass(ClassInfoCollection list)
        {
            ClassInfoCollection result = new ClassInfoCollection();
            foreach (var clsInfo in list)
            {
                if (clsInfo.IsEnable)
                {
                    result.Add(clsInfo);
                }
            }
            return result;
        }

        private PropInfoCollection DeleteDisable(PropInfoCollection list)
        {
            var result = new PropInfoCollection();
            foreach (var info in list)
            {
                if (info.IsDisable == false)
                {
                    result.Add(info);
                }
            }
            return result;
        }





        private PropInfoCollection DeleteSetOnly(PropInfoCollection list)
        {
            var result = new PropInfoCollection();
            foreach (var info in list)
            {
                if (GetRank(info) < 2)
                {

                }
                else
                {
                    result.Add(info);
                }
            }
            return result;
        }

        private PropInfoCollection DeleteOverlapName(PropInfoCollection list)
        {
            var result = new PropInfoCollection();
            foreach (var info in list)
            {
                PropInfo findResult = result.Find(delegate(PropInfo obj) { return obj.Name == info.Name; });
                if (findResult == null)
                {
                    result.Add(info);
                }
                else
                {
                    if (Compare(info, findResult) > 0)
                    {
                        result.Remove(findResult);
                        result.Add(info);
                    }
                }
            }
            return result;
        }
        private int Compare(PropInfo x, PropInfo y)
        {
            int xRank = GetRank(x);
            int yRank = GetRank(y);
            return xRank - yRank;
        }

        private int GetRank(PropInfo x)
        {
            if (x.IsGet == true && x.IsSet == true) { return 3; }
            if (x.IsGet == false && x.IsSet == true) { return 1; }
            if (x.IsGet == true && x.IsSet == false) { return 2; }
            if (x.IsGet == false && x.IsSet == false) { return 0; }
            return 0;
        }
    }
}
