﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

namespace ParseInclude
{
    class Program
    {
        private static List<HeaderInfo> _list = new List<HeaderInfo>();
        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("Error:Need args.");
                Console.WriteLine("usage: ParseInclude.exe <ヘッダファイルパス>\\*.h");
                return;
            }

            List<string> headerPath = new List<string>();
            foreach (var arg in args)
            {
                string dir = Path.GetDirectoryName(arg);
                string file = Path.GetFileName(arg);
                string[] paths = System.IO.Directory.GetFiles(dir, file, SearchOption.TopDirectoryOnly);
                headerPath.AddRange(paths);
            }
            foreach (var header in headerPath)
            {
                HeaderInfo info = new HeaderInfo();
                info.Path = header;
                info.Name = Path.GetFileNameWithoutExtension(header);
                info.IsOutput = false;
                _list.Add(info);
            }


            foreach (var headerInfo in _list)
            {
                bool result;
                try
                {
                    PrintHeader(headerInfo);
                }
                catch (Exception e)
                {
                    System.Console.WriteLine(e.ToString());
                    Environment.Exit(1);
                }
            }
        }

        private static void PrintHeader(HeaderInfo headerInfo)
        {
            if (headerInfo.IsOutput == true)
            {
                return;
            }
            string[] headerList = SearchDependHeader(headerInfo.Path);
            foreach (var headerPath in headerList)
            {
                HeaderInfo info = GetHeaderInfo(headerPath);
                if (info != null)
                {
                    PrintHeader(info);
                }
            }
            headerInfo.IsOutput = true;
            Console.WriteLine("%include \"{0}.h\"", headerInfo.Name);
        }

        private static HeaderInfo GetHeaderInfo(string headerName)
        {
            foreach (var info in _list)
            {
                if(info.Name == headerName)
                {
                    return info;
                }
            }
            return null;
        }

        private static string[] SearchDependHeader(string headerPath)
        {
            FileStream fs = new FileStream(headerPath, FileMode.Open, FileAccess.Read);
            StreamReader sr = new StreamReader(fs, Encoding.Default);
            string str = sr.ReadToEnd();
            sr.Close();

            List<string> dependHeaderFiles = new List<string>();
            Regex includeInHeaderRegex = new Regex("#include *\"(?<filename>.+)\\.h\"");
            MatchCollection matches = includeInHeaderRegex.Matches(str);
            foreach (Match match in matches)
            {
                string dependHeaderFile = match.Groups["filename"].Value;
                dependHeaderFiles.Add(dependHeaderFile);
            }
            return dependHeaderFiles.ToArray();
        }
    }

    internal class HeaderInfo
    {
        public string Name = "";
        public string Path = "";
        public bool IsOutput = false;
    }
}
