﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IrrlichtNetSwig
{
    public partial class IMeshBuffer
    {
        public void append(S3DVertex[] vertices, uint numVertices, ushort[] indices, uint numIndices)
        {
            var arr = (S3DVertexArray)vertices;
            append(arr.cast(), numVertices, indices, numIndices);
        }

        public void append(S3DVertex2TCoords[] vertices, uint numVertices, ushort[] indices, uint numIndices)
        {
            var arr = (S3DVertex2TCoordsArray)vertices;
            append(arr.cast(), numVertices, indices, numIndices);
        }

        public void append(S3DVertexTangents[] vertices, uint numVertices, ushort[] indices, uint numIndices)
        {
            var arr = (S3DVertexTangentsArray)vertices;
            append(arr.cast(), numVertices, indices, numIndices);
        }
        public virtual S3DVertex[] getVerticesAsS3DVertex()
        {
            return _getVerticesAsS3DVertex().ToArray();
        }
        public virtual S3DVertex2TCoords[] getVerticesAsS3DVertex2TCoords()
        {
            return _getVerticesAsS3DVertex2TCoords().ToArray();
        }
        public virtual S3DVertexTangents[] getVerticesAsS3DVertexTangents()
        {
            return _getVerticesAsS3DVertexTangents().ToArray();
        }
        public virtual ushort[] getIndices()
        {
            return _getIndices().ToArray();
        }
    }
}
