﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using Commons.Collections;
using NVelocity;
using NVelocity.App;

namespace CreatePropertyCS
{
    class Program
    {
        static void Main(string[] args)
        {
            ClassInfoCollection list = new ClassInfoCollection();

            if(args.Length<2)
            {
                Console.WriteLine("Error:Excepted CreatePropertyCS.exe <input directory> <output directory>");
                Environment.Exit(1);
            }

            string inputDir = args[0];
            string outputDir = args[1];

            if (System.IO.Directory.Exists(inputDir) == false)
            {
                Console.WriteLine("Error:{0} is not exists.", inputDir);
                Environment.Exit(1);
            }
            if (System.IO.Directory.Exists(outputDir) == false)
            {
                System.IO.Directory.CreateDirectory(outputDir);
            }


            PropertyParser parser = new PropertyParser();

            string[] files = System.IO.Directory.GetFiles(inputDir, "*.cs", SearchOption.TopDirectoryOnly);
            foreach (var filePath in files)
            {
                ClassInfoCollection tmplist = parser.ParseCSFile(filePath);
                list.AddRange(tmplist);
            }

            var ignoreRepository = new IgnoreFileRepository(inputDir);
            var exeDir = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            var ignoreFilePath = System.IO.Path.Combine(exeDir, "ignore.txt");
            if (System.IO.File.Exists(ignoreFilePath))
            {
                var ignoreList = ignoreRepository.Load(ignoreFilePath);
                list = list.Marge(ignoreList);
            }

            var repository = new CSharpFileRepository("clsfiletemplate.vm");

            foreach (ClassInfo clsInfo in list)
            {
                repository.Save(clsInfo.GetFilePathWithhoutExtension() + "_prop.cs", clsInfo);
            }
        }

    }
}
