﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CreatePropertyCS
{
    class PropInfo
    {
        /// <summary>
        /// 説明を取得/設定します
        /// </summary>
        public string Prefix { get; set; }

        /// <summary>
        /// 型を取得/設定します
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// プロパティ名を取得/設定します
        /// </summary>
        public string Name { get; set; }

        public bool IsGet { get; set; }

        public bool IsSet { get; set; }

        public bool IsDisable { get; set; }

        internal PropInfo DeepCopy()
        {
            PropInfo info = new PropInfo();
            info.IsDisable = this.IsDisable;
            info.IsGet = this.IsGet;
            info.IsSet = this.IsSet;
            info.Name = this.Name;
            info.Prefix = this.Prefix;
            info.Type = this.Type;
            return info;
        }

        internal PropInfo Marge(PropInfo prop)
        {
            var newProp = DeepCopy();
            if (newProp.Prefix == "")
            {
                newProp.Prefix = prop.Prefix;
            }
            if (newProp.Type == "")
            {
                newProp.Type = prop.Type;
            }
            newProp.IsGet |= prop.IsGet;
            newProp.IsSet |= prop.IsSet;
            newProp.IsDisable |= prop.IsDisable;
            return newProp;
        }
    }
}
