//
// Inclusion of standard header file
//
#include <algorithm>

//
// Inclusion of local header file
//
#include "fatal_error.hpp"
#include "islibfunc.hpp"

namespace islib
  {
    //
    // Definition of constructor
    //
    fatal_error::fatal_error
      (
        char const *parameter_message
      ):
      message ( parameter_message )
      {
        class local
          {
          public:
            local
              (
                char const *local_message
              )
              {
                islib_assert_with_message ( local_message, islib::fatal_error::fatal_error );
              }

            ~local
              (
              )
              throw
              (
              )
              {
              }
          }
        a_local ( parameter_message );
      }

    //
    // Definition of constructor
    //
    fatal_error::fatal_error
      (
        this_type const &the_other
      ):
      message ( the_other.message )
      {
      }

    //
    // Definition of destructor
    //
    fatal_error::~fatal_error
      (
      )
      throw
      (
      )
      {
      }

    //
    // Definition of non-static operator
    //
    fatal_error::this_type &
      fatal_error::operator =
      (
        this_type const &right_hand_side
      )
      {
        this_type temporary ( right_hand_side );

        this->swap ( temporary );

        return *this;
      }

    //
    // Definition of non-static member function
    //
    char const *
      fatal_error::what
      (
      )
      const
      throw
      (
      )
      {
        char const *a_message = 0;

        class local
          {
          public:
            local
              (
                char const * const &parameter_local_message
              ):
              local_message ( parameter_local_message )
              {
              }

            ~local
              (
              )
              throw
                (
                )
              {
                islib_assert_with_message ( this->local_message, islib::fatal_error::what );
              }

          private:
            char const * const &local_message;
          }
        a_local ( a_message );

        a_message = this->message;

        return a_message;
      }

    //
    // Definition of non-static member function
    //
    void
      fatal_error::swap
      (
        this_type &the_other
      )
      throw
      (
      )
      {
        std::swap ( this->message, the_other.message );
      }
  }

//
// End of file
//
