#ifndef DEFINE_ISLIB_FATAL_ERROR_HPP

#define DEFINE_ISLIB_FATAL_ERROR_HPP

namespace islib
  {
    //
    // Definition of class
    //
    class fatal_error
      {
      public:
        //
        // Definition of type
        //
        typedef fatal_error this_type;

        //
        // Declaration of constructor
        //
        explicit fatal_error ( char const * );
        fatal_error ( this_type const & );

        //
        // Declaration of destructor
        //
        virtual ~fatal_error () throw ();

        //
        // Declaration of non-static operator
        //
        this_type &operator = ( this_type const & );

        //
        // Declaration of non-static member function
        //
        virtual char const *what () const throw ();
        virtual void swap ( this_type & ) throw ();

      private:
        //
        // Definition of non-static data member
        //
        char const *message;
      };
  }

#endif // DEFINE_ISLIB_FATAL_ERROR_HPP

//
// End of file
//
